/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.bytecode.internal.javassist;

import java.io.IOException;
import org.evosuite.shaded.javassist.CannotCompileException;
import org.evosuite.shaded.javassist.ClassPool;
import org.evosuite.shaded.javassist.CtClass;
import org.evosuite.shaded.javassist.NotFoundException;
import org.evosuite.shaded.org.hibernate.HibernateException;

public class TransformingClassLoader
extends ClassLoader {
    private ClassLoader parent;
    private ClassPool classPool;

    TransformingClassLoader(ClassLoader parent, String[] classpaths) {
        this.parent = parent;
        this.classPool = new ClassPool(true);
        for (String classpath : classpaths) {
            try {
                this.classPool.appendClassPath(classpath);
            }
            catch (NotFoundException e) {
                throw new HibernateException("Unable to resolve requested classpath for transformation [" + classpath + "] : " + e.getMessage());
            }
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        try {
            CtClass cc = this.classPool.get(name);
            byte[] b = cc.toBytecode();
            return this.defineClass(name, b, 0, b.length);
        }
        catch (NotFoundException e) {
            throw new ClassNotFoundException();
        }
        catch (IOException e) {
            throw new ClassNotFoundException();
        }
        catch (CannotCompileException e) {
            throw new ClassNotFoundException();
        }
    }

    public void release() {
        this.classPool = null;
        this.parent = null;
    }
}

