/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.cache.spi.entry;

import java.io.Serializable;
import org.evosuite.shaded.org.hibernate.AssertionFailure;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.Interceptor;
import org.evosuite.shaded.org.hibernate.cache.spi.entry.CacheEntry;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.event.service.spi.EventListenerGroup;
import org.evosuite.shaded.org.hibernate.event.service.spi.EventListenerRegistry;
import org.evosuite.shaded.org.hibernate.event.spi.EventSource;
import org.evosuite.shaded.org.hibernate.event.spi.EventType;
import org.evosuite.shaded.org.hibernate.event.spi.PreLoadEvent;
import org.evosuite.shaded.org.hibernate.event.spi.PreLoadEventListener;
import org.evosuite.shaded.org.hibernate.internal.util.collections.ArrayHelper;
import org.evosuite.shaded.org.hibernate.persister.entity.EntityPersister;
import org.evosuite.shaded.org.hibernate.type.TypeHelper;

public class StandardCacheEntryImpl
implements CacheEntry {
    private final Serializable[] disassembledState;
    private final String subclass;
    private final boolean lazyPropertiesAreUnfetched;
    private final Object version;

    public StandardCacheEntryImpl(Object[] state, EntityPersister persister, boolean unfetched, Object version, SessionImplementor session, Object owner) throws HibernateException {
        this.disassembledState = TypeHelper.disassemble(state, persister.getPropertyTypes(), persister.isLazyPropertiesCacheable() ? null : persister.getPropertyLaziness(), session, owner);
        this.subclass = persister.getEntityName();
        this.lazyPropertiesAreUnfetched = unfetched || !persister.isLazyPropertiesCacheable();
        this.version = version;
    }

    StandardCacheEntryImpl(Serializable[] state, String subclass, boolean unfetched, Object version) {
        this.disassembledState = state;
        this.subclass = subclass;
        this.lazyPropertiesAreUnfetched = unfetched;
        this.version = version;
    }

    @Override
    public boolean isReferenceEntry() {
        return false;
    }

    @Override
    public Serializable[] getDisassembledState() {
        return this.disassembledState;
    }

    @Override
    public String getSubclass() {
        return this.subclass;
    }

    @Override
    public boolean areLazyPropertiesUnfetched() {
        return this.lazyPropertiesAreUnfetched;
    }

    @Override
    public Object getVersion() {
        return this.version;
    }

    public boolean isDeepCopyNeeded() {
        return true;
    }

    public Object[] assemble(Object instance, Serializable id, EntityPersister persister, Interceptor interceptor, EventSource session) throws HibernateException {
        if (!persister.getEntityName().equals(this.subclass)) {
            throw new AssertionFailure("Tried to assemble a different subclass instance");
        }
        Object[] assembledProps = TypeHelper.assemble(this.disassembledState, persister.getPropertyTypes(), session, instance);
        PreLoadEvent preLoadEvent = new PreLoadEvent(session).setEntity(instance).setState(assembledProps).setId(id).setPersister(persister);
        EventListenerGroup<PreLoadEventListener> listenerGroup = session.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.PRE_LOAD);
        for (PreLoadEventListener listener : listenerGroup.listeners()) {
            listener.onPreLoad(preLoadEvent);
        }
        persister.setPropertyValues(instance, assembledProps);
        return assembledProps;
    }

    public String toString() {
        return "CacheEntry(" + this.subclass + ')' + ArrayHelper.toString(this.disassembledState);
    }
}

