/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.cfg;

import org.evosuite.shaded.org.hibernate.cfg.NamingStrategy;
import org.evosuite.shaded.org.hibernate.cfg.naming.NamingStrategyDelegator;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;

public abstract class ObjectNameNormalizer {
    public String normalizeDatabaseIdentifier(String explicitName, NamingStrategyHelper helper) {
        String objectName = null;
        if (!StringHelper.isEmpty(explicitName)) {
            objectName = this.normalizeIdentifierQuoting(explicitName);
            objectName = helper.handleExplicitName(this.getNamingStrategyDelegator(), objectName);
            return this.normalizeIdentifierQuoting(objectName);
        }
        objectName = helper.determineImplicitName(this.getNamingStrategyDelegator());
        return this.normalizeIdentifierQuoting(objectName);
    }

    public String normalizeIdentifierQuoting(String identifier) {
        if (StringHelper.isEmpty(identifier)) {
            return null;
        }
        if (identifier.startsWith("\"") && identifier.endsWith("\"")) {
            return '`' + identifier.substring(1, identifier.length() - 1) + '`';
        }
        if (identifier.startsWith("[") && identifier.endsWith("]")) {
            return '`' + identifier.substring(1, identifier.length() - 1) + '`';
        }
        if (!(!this.isUseQuotedIdentifiersGlobally() || identifier.startsWith("`") && identifier.endsWith("`"))) {
            return '`' + identifier + '`';
        }
        return identifier;
    }

    protected abstract boolean isUseQuotedIdentifiersGlobally();

    @Deprecated
    protected abstract NamingStrategy getNamingStrategy();

    protected abstract NamingStrategyDelegator getNamingStrategyDelegator();

    public static interface NamingStrategyHelper {
        @Deprecated
        public String determineImplicitName(NamingStrategy var1);

        @Deprecated
        public String handleExplicitName(NamingStrategy var1, String var2);

        public String determineImplicitName(NamingStrategyDelegator var1);

        public String handleExplicitName(NamingStrategyDelegator var1, String var2);
    }
}

