/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.cfg;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.evosuite.shaded.org.hibernate.ConnectionReleaseMode;
import org.evosuite.shaded.org.hibernate.EntityMode;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.MultiTenancyStrategy;
import org.evosuite.shaded.org.hibernate.NullPrecedence;
import org.evosuite.shaded.org.hibernate.SessionEventListener;
import org.evosuite.shaded.org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.evosuite.shaded.org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.evosuite.shaded.org.hibernate.cache.internal.NoCachingRegionFactory;
import org.evosuite.shaded.org.hibernate.cache.internal.RegionFactoryInitiator;
import org.evosuite.shaded.org.hibernate.cache.internal.StandardQueryCacheFactory;
import org.evosuite.shaded.org.hibernate.cache.spi.QueryCacheFactory;
import org.evosuite.shaded.org.hibernate.cache.spi.RegionFactory;
import org.evosuite.shaded.org.hibernate.cfg.BaselineSessionEventsListenerBuilder;
import org.evosuite.shaded.org.hibernate.cfg.Settings;
import org.evosuite.shaded.org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.evosuite.shaded.org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.ExtractedDatabaseMetaData;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.JdbcServices;
import org.evosuite.shaded.org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionFactory;
import org.evosuite.shaded.org.hibernate.hql.spi.MultiTableBulkIdStrategy;
import org.evosuite.shaded.org.hibernate.hql.spi.PersistentTableBulkIdStrategy;
import org.evosuite.shaded.org.hibernate.hql.spi.QueryTranslatorFactory;
import org.evosuite.shaded.org.hibernate.hql.spi.TemporaryTableBulkIdStrategy;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.internal.util.ReflectHelper;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;
import org.evosuite.shaded.org.hibernate.internal.util.config.ConfigurationHelper;
import org.evosuite.shaded.org.hibernate.loader.BatchFetchStyle;
import org.evosuite.shaded.org.hibernate.service.ServiceRegistry;
import org.evosuite.shaded.org.hibernate.tuple.entity.EntityTuplizerFactory;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class SettingsFactory
implements Serializable {
    private static final long serialVersionUID = -1194386144994524825L;
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SettingsFactory.class.getName());
    public static final String DEF_CACHE_REG_FACTORY = NoCachingRegionFactory.class.getName();

    public Settings buildSettings(Properties props, ServiceRegistry serviceRegistry) {
        ConnectionReleaseMode releaseMode;
        boolean debugEnabled = LOG.isDebugEnabled();
        JdbcServices jdbcServices = serviceRegistry.getService(JdbcServices.class);
        StrategySelector strategySelector = serviceRegistry.getService(StrategySelector.class);
        Settings settings = new Settings();
        String sessionFactoryName = props.getProperty("hibernate.session_factory_name");
        settings.setSessionFactoryName(sessionFactoryName);
        settings.setSessionFactoryNameAlsoJndiName(ConfigurationHelper.getBoolean("hibernate.session_factory_name_is_jndi", props, true));
        ExtractedDatabaseMetaData meta = jdbcServices.getExtractedMetaDataSupport();
        settings.setDataDefinitionImplicitCommit(meta.doesDataDefinitionCauseTransactionCommit());
        settings.setDataDefinitionInTransactionSupported(meta.supportsDataDefinitionInTransaction());
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)jdbcServices.getDialect().getDefaultProperties());
        properties.putAll((Map<?, ?>)props);
        settings.setJtaPlatform(serviceRegistry.getService(JtaPlatform.class));
        MultiTableBulkIdStrategy multiTableBulkIdStrategy = strategySelector.resolveStrategy(MultiTableBulkIdStrategy.class, properties.getProperty("hibernate.hql.bulk_id_strategy"));
        if (multiTableBulkIdStrategy == null) {
            multiTableBulkIdStrategy = jdbcServices.getDialect().supportsTemporaryTables() ? TemporaryTableBulkIdStrategy.INSTANCE : new PersistentTableBulkIdStrategy();
        }
        settings.setMultiTableBulkIdStrategy(multiTableBulkIdStrategy);
        boolean flushBeforeCompletion = ConfigurationHelper.getBoolean("hibernate.transaction.flush_before_completion", properties);
        if (debugEnabled) {
            LOG.debugf("Automatic flush during beforeCompletion(): %s", (Object)SettingsFactory.enabledDisabled(flushBeforeCompletion));
        }
        settings.setFlushBeforeCompletionEnabled(flushBeforeCompletion);
        boolean autoCloseSession = ConfigurationHelper.getBoolean("hibernate.transaction.auto_close_session", properties);
        if (debugEnabled) {
            LOG.debugf("Automatic session close at end of transaction: %s", (Object)SettingsFactory.enabledDisabled(autoCloseSession));
        }
        settings.setAutoCloseSessionEnabled(autoCloseSession);
        int batchSize = ConfigurationHelper.getInt("hibernate.jdbc.batch_size", properties, 0);
        if (!meta.supportsBatchUpdates()) {
            batchSize = 0;
        }
        if (batchSize > 0 && debugEnabled) {
            LOG.debugf("JDBC batch size: %s", (Object)batchSize);
        }
        settings.setJdbcBatchSize(batchSize);
        boolean jdbcBatchVersionedData = ConfigurationHelper.getBoolean("hibernate.jdbc.batch_versioned_data", properties, false);
        if (batchSize > 0 && debugEnabled) {
            LOG.debugf("JDBC batch updates for versioned data: %s", (Object)SettingsFactory.enabledDisabled(jdbcBatchVersionedData));
        }
        settings.setJdbcBatchVersionedData(jdbcBatchVersionedData);
        boolean useScrollableResultSets = ConfigurationHelper.getBoolean("hibernate.jdbc.use_scrollable_resultset", properties, meta.supportsScrollableResults());
        if (debugEnabled) {
            LOG.debugf("Scrollable result sets: %s", (Object)SettingsFactory.enabledDisabled(useScrollableResultSets));
        }
        settings.setScrollableResultSetsEnabled(useScrollableResultSets);
        boolean wrapResultSets = ConfigurationHelper.getBoolean("hibernate.jdbc.wrap_result_sets", properties, false);
        if (debugEnabled) {
            LOG.debugf("Wrap result sets: %s", (Object)SettingsFactory.enabledDisabled(wrapResultSets));
        }
        settings.setWrapResultSetsEnabled(wrapResultSets);
        boolean useGetGeneratedKeys = ConfigurationHelper.getBoolean("hibernate.jdbc.use_get_generated_keys", properties, meta.supportsGetGeneratedKeys());
        if (debugEnabled) {
            LOG.debugf("JDBC3 getGeneratedKeys(): %s", (Object)SettingsFactory.enabledDisabled(useGetGeneratedKeys));
        }
        settings.setGetGeneratedKeysEnabled(useGetGeneratedKeys);
        Integer statementFetchSize = ConfigurationHelper.getInteger("hibernate.jdbc.fetch_size", properties);
        if (statementFetchSize != null && debugEnabled) {
            LOG.debugf("JDBC result set fetch size: %s", (Object)statementFetchSize);
        }
        settings.setJdbcFetchSize(statementFetchSize);
        MultiTenancyStrategy multiTenancyStrategy = MultiTenancyStrategy.determineMultiTenancyStrategy(properties);
        if (debugEnabled) {
            LOG.debugf("multi-tenancy strategy : %s", (Object)multiTenancyStrategy);
        }
        settings.setMultiTenancyStrategy(multiTenancyStrategy);
        String releaseModeName = ConfigurationHelper.getString("hibernate.connection.release_mode", properties, "auto");
        if (debugEnabled) {
            LOG.debugf("Connection release mode: %s", (Object)releaseModeName);
        }
        if ("auto".equals(releaseModeName)) {
            releaseMode = serviceRegistry.getService(TransactionFactory.class).getDefaultReleaseMode();
        } else {
            releaseMode = ConnectionReleaseMode.parse(releaseModeName);
            if (releaseMode == ConnectionReleaseMode.AFTER_STATEMENT) {
                boolean supportsAgrressiveRelease;
                boolean bl = supportsAgrressiveRelease = multiTenancyStrategy.requiresMultiTenantConnectionProvider() ? serviceRegistry.getService(MultiTenantConnectionProvider.class).supportsAggressiveRelease() : serviceRegistry.getService(ConnectionProvider.class).supportsAggressiveRelease();
                if (!supportsAgrressiveRelease) {
                    LOG.unsupportedAfterStatement();
                    releaseMode = ConnectionReleaseMode.AFTER_TRANSACTION;
                }
            }
        }
        settings.setConnectionReleaseMode(releaseMode);
        BatchFetchStyle batchFetchStyle = BatchFetchStyle.interpret(properties.get("hibernate.batch_fetch_style"));
        LOG.debugf("Using BatchFetchStyle : " + batchFetchStyle.name(), new Object[0]);
        settings.setBatchFetchStyle(batchFetchStyle);
        String defaultSchema = properties.getProperty("hibernate.default_schema");
        String defaultCatalog = properties.getProperty("hibernate.default_catalog");
        if (defaultSchema != null && debugEnabled) {
            LOG.debugf("Default schema: %s", (Object)defaultSchema);
        }
        if (defaultCatalog != null && debugEnabled) {
            LOG.debugf("Default catalog: %s", (Object)defaultCatalog);
        }
        settings.setDefaultSchemaName(defaultSchema);
        settings.setDefaultCatalogName(defaultCatalog);
        Integer maxFetchDepth = ConfigurationHelper.getInteger("hibernate.max_fetch_depth", properties);
        if (maxFetchDepth != null) {
            LOG.debugf("Maximum outer join fetch depth: %s", (Object)maxFetchDepth);
        }
        settings.setMaximumFetchDepth(maxFetchDepth);
        int batchFetchSize = ConfigurationHelper.getInt("hibernate.default_batch_fetch_size", properties, 1);
        if (debugEnabled) {
            LOG.debugf("Default batch fetch size: %s", (Object)batchFetchSize);
        }
        settings.setDefaultBatchFetchSize(batchFetchSize);
        boolean comments = ConfigurationHelper.getBoolean("hibernate.use_sql_comments", properties);
        if (debugEnabled) {
            LOG.debugf("Generate SQL with comments: %s", (Object)SettingsFactory.enabledDisabled(comments));
        }
        settings.setCommentsEnabled(comments);
        boolean orderUpdates = ConfigurationHelper.getBoolean("hibernate.order_updates", properties);
        if (debugEnabled) {
            LOG.debugf("Order SQL updates by primary key: %s", (Object)SettingsFactory.enabledDisabled(orderUpdates));
        }
        settings.setOrderUpdatesEnabled(orderUpdates);
        boolean orderInserts = ConfigurationHelper.getBoolean("hibernate.order_inserts", properties);
        if (debugEnabled) {
            LOG.debugf("Order SQL inserts for batching: %s", (Object)SettingsFactory.enabledDisabled(orderInserts));
        }
        settings.setOrderInsertsEnabled(orderInserts);
        String defaultNullPrecedence = ConfigurationHelper.getString("hibernate.order_by.default_null_ordering", properties, "none", "first", "last");
        if (debugEnabled) {
            LOG.debugf("Default null ordering: %s", (Object)defaultNullPrecedence);
        }
        settings.setDefaultNullPrecedence(NullPrecedence.parse(defaultNullPrecedence));
        settings.setQueryTranslatorFactory(this.createQueryTranslatorFactory(properties, serviceRegistry));
        Map querySubstitutions = ConfigurationHelper.toMap("hibernate.query.substitutions", " ,=;:\n\t\r\f", properties);
        if (debugEnabled) {
            LOG.debugf("Query language substitutions: %s", (Object)querySubstitutions);
        }
        settings.setQuerySubstitutions(querySubstitutions);
        boolean jpaqlCompliance = ConfigurationHelper.getBoolean("hibernate.query.jpaql_strict_compliance", properties, false);
        if (debugEnabled) {
            LOG.debugf("JPA-QL strict compliance: %s", (Object)SettingsFactory.enabledDisabled(jpaqlCompliance));
        }
        settings.setStrictJPAQLCompliance(jpaqlCompliance);
        boolean useSecondLevelCache = ConfigurationHelper.getBoolean("hibernate.cache.use_second_level_cache", properties, true);
        if (debugEnabled) {
            LOG.debugf("Second-level cache: %s", (Object)SettingsFactory.enabledDisabled(useSecondLevelCache));
        }
        settings.setSecondLevelCacheEnabled(useSecondLevelCache);
        boolean useQueryCache = ConfigurationHelper.getBoolean("hibernate.cache.use_query_cache", properties);
        if (debugEnabled) {
            LOG.debugf("Query cache: %s", (Object)SettingsFactory.enabledDisabled(useQueryCache));
        }
        settings.setQueryCacheEnabled(useQueryCache);
        if (useQueryCache) {
            settings.setQueryCacheFactory(this.createQueryCacheFactory(properties, serviceRegistry));
        }
        settings.setRegionFactory(serviceRegistry.getService(RegionFactory.class));
        boolean useMinimalPuts = ConfigurationHelper.getBoolean("hibernate.cache.use_minimal_puts", properties, settings.getRegionFactory().isMinimalPutsEnabledByDefault());
        if (debugEnabled) {
            LOG.debugf("Optimize cache for minimal puts: %s", (Object)SettingsFactory.enabledDisabled(useMinimalPuts));
        }
        settings.setMinimalPutsEnabled(useMinimalPuts);
        String prefix = properties.getProperty("hibernate.cache.region_prefix");
        if (StringHelper.isEmpty(prefix)) {
            prefix = null;
        }
        if (prefix != null && debugEnabled) {
            LOG.debugf("Cache region prefix: %s", (Object)prefix);
        }
        settings.setCacheRegionPrefix(prefix);
        boolean useStructuredCacheEntries = ConfigurationHelper.getBoolean("hibernate.cache.use_structured_entries", properties, false);
        if (debugEnabled) {
            LOG.debugf("Structured second-level cache entries: %s", (Object)SettingsFactory.enabledDisabled(useStructuredCacheEntries));
        }
        settings.setStructuredCacheEntriesEnabled(useStructuredCacheEntries);
        boolean useDirectReferenceCacheEntries = ConfigurationHelper.getBoolean("hibernate.cache.use_reference_entries", properties, false);
        if (debugEnabled) {
            LOG.debugf("Second-level cache direct-reference entries: %s", (Object)SettingsFactory.enabledDisabled(useDirectReferenceCacheEntries));
        }
        settings.setDirectReferenceCacheEntriesEnabled(useDirectReferenceCacheEntries);
        boolean autoEvictCollectionCache = ConfigurationHelper.getBoolean("hibernate.cache.auto_evict_collection_cache", properties, false);
        if (debugEnabled) {
            LOG.debugf("Automatic eviction of collection cache: %s", (Object)SettingsFactory.enabledDisabled(autoEvictCollectionCache));
        }
        settings.setAutoEvictCollectionCache(autoEvictCollectionCache);
        boolean useStatistics = ConfigurationHelper.getBoolean("hibernate.generate_statistics", properties);
        if (debugEnabled) {
            LOG.debugf("Statistics: %s", (Object)SettingsFactory.enabledDisabled(useStatistics));
        }
        settings.setStatisticsEnabled(useStatistics);
        boolean useIdentifierRollback = ConfigurationHelper.getBoolean("hibernate.use_identifier_rollback", properties);
        if (debugEnabled) {
            LOG.debugf("Deleted entity synthetic identifier rollback: %s", (Object)SettingsFactory.enabledDisabled(useIdentifierRollback));
        }
        settings.setIdentifierRollbackEnabled(useIdentifierRollback);
        String autoSchemaExport = properties.getProperty("hibernate.hbm2ddl.auto");
        if ("validate".equals(autoSchemaExport)) {
            settings.setAutoValidateSchema(true);
        } else if ("update".equals(autoSchemaExport)) {
            settings.setAutoUpdateSchema(true);
        } else if ("create".equals(autoSchemaExport)) {
            settings.setAutoCreateSchema(true);
        } else if ("create-drop".equals(autoSchemaExport)) {
            settings.setAutoCreateSchema(true);
            settings.setAutoDropSchema(true);
        } else if (!StringHelper.isEmpty(autoSchemaExport)) {
            LOG.warn("Unrecognized value for \"hibernate.hbm2ddl.auto\": " + autoSchemaExport);
        }
        settings.setImportFiles(properties.getProperty("hibernate.hbm2ddl.import_files"));
        EntityMode defaultEntityMode = EntityMode.parse(properties.getProperty("hibernate.default_entity_mode"));
        if (debugEnabled) {
            LOG.debugf("Default entity-mode: %s", (Object)defaultEntityMode);
        }
        settings.setDefaultEntityMode(defaultEntityMode);
        boolean namedQueryChecking = ConfigurationHelper.getBoolean("hibernate.query.startup_check", properties, true);
        if (debugEnabled) {
            LOG.debugf("Named query checking : %s", (Object)SettingsFactory.enabledDisabled(namedQueryChecking));
        }
        settings.setNamedQueryStartupCheckingEnabled(namedQueryChecking);
        boolean checkNullability = ConfigurationHelper.getBoolean("hibernate.check_nullability", properties, true);
        if (debugEnabled) {
            LOG.debugf("Check Nullability in Core (should be disabled when Bean Validation is on): %s", (Object)SettingsFactory.enabledDisabled(checkNullability));
        }
        settings.setCheckNullability(checkNullability);
        settings.setEntityTuplizerFactory(new EntityTuplizerFactory());
        boolean initializeLazyStateOutsideTransactionsEnabled = ConfigurationHelper.getBoolean("hibernate.enable_lazy_load_no_trans", properties, false);
        if (debugEnabled) {
            LOG.debugf("Allow initialization of lazy state outside session : : %s", (Object)SettingsFactory.enabledDisabled(initializeLazyStateOutsideTransactionsEnabled));
        }
        settings.setInitializeLazyStateOutsideTransactions(initializeLazyStateOutsideTransactionsEnabled);
        boolean jtaTrackByThread = ConfigurationHelper.getBoolean("hibernate.jta.track_by_thread", properties, true);
        if (debugEnabled) {
            LOG.debugf("JTA Track by Thread: %s", (Object)SettingsFactory.enabledDisabled(jtaTrackByThread));
        }
        settings.setJtaTrackByThread(jtaTrackByThread);
        String autoSessionEventsListenerName = properties.getProperty("hibernate.session.events.auto");
        Class<SessionEventListener> autoSessionEventsListener = autoSessionEventsListenerName == null ? null : strategySelector.selectStrategyImplementor(SessionEventListener.class, autoSessionEventsListenerName);
        boolean logSessionMetrics = ConfigurationHelper.getBoolean("hibernate.session.events.log", properties, useStatistics);
        settings.setBaselineSessionEventsListenerBuilder(new BaselineSessionEventsListenerBuilder(logSessionMetrics, autoSessionEventsListener));
        return settings;
    }

    private static String enabledDisabled(boolean value) {
        return value ? "enabled" : "disabled";
    }

    protected QueryCacheFactory createQueryCacheFactory(Properties properties, ServiceRegistry serviceRegistry) {
        String queryCacheFactoryClassName = ConfigurationHelper.getString("hibernate.cache.query_cache_factory", properties, StandardQueryCacheFactory.class.getName());
        LOG.debugf("Query cache factory: %s", (Object)queryCacheFactoryClassName);
        try {
            return (QueryCacheFactory)serviceRegistry.getService(ClassLoaderService.class).classForName(queryCacheFactoryClassName).newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("could not instantiate QueryCacheFactory: " + queryCacheFactoryClassName, e);
        }
    }

    public static RegionFactory createRegionFactory(Properties properties, boolean cachingEnabled) {
        String regionFactoryClassName = RegionFactoryInitiator.mapLegacyNames(ConfigurationHelper.getString("hibernate.cache.region.factory_class", properties, null));
        if (regionFactoryClassName == null) {
            regionFactoryClassName = DEF_CACHE_REG_FACTORY;
        }
        LOG.debugf("Cache region factory : %s", (Object)regionFactoryClassName);
        try {
            try {
                return (RegionFactory)ReflectHelper.classForName(regionFactoryClassName).getConstructor(Properties.class).newInstance(properties);
            }
            catch (NoSuchMethodException e) {
                LOG.debugf("%s did not provide constructor accepting java.util.Properties; attempting no-arg constructor.", (Object)regionFactoryClassName);
                return (RegionFactory)ReflectHelper.classForName(regionFactoryClassName).newInstance();
            }
        }
        catch (Exception e) {
            throw new HibernateException("could not instantiate RegionFactory [" + regionFactoryClassName + "]", e);
        }
    }

    protected QueryTranslatorFactory createQueryTranslatorFactory(Properties properties, ServiceRegistry serviceRegistry) {
        String className = ConfigurationHelper.getString("hibernate.query.factory_class", properties, "org.evosuite.shaded.org.hibernate.hql.internal.ast.ASTQueryTranslatorFactory");
        LOG.debugf("Query translator: %s", (Object)className);
        try {
            return (QueryTranslatorFactory)serviceRegistry.getService(ClassLoaderService.class).classForName(className).newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("could not instantiate QueryTranslatorFactory: " + className, e);
        }
    }
}

