/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.dialect.function;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.dialect.function.SQLFunction;

public class SQLFunctionRegistry {
    private final Dialect dialect;
    private final Map<String, SQLFunction> userFunctions;

    public SQLFunctionRegistry(Dialect dialect, Map<String, SQLFunction> userFunctions) {
        this.dialect = dialect;
        this.userFunctions = new HashMap<String, SQLFunction>(userFunctions);
    }

    public SQLFunction findSQLFunction(String functionName) {
        String name = functionName.toLowerCase(Locale.ROOT);
        SQLFunction userFunction = this.userFunctions.get(name);
        return userFunction != null ? userFunction : this.dialect.getFunctions().get(name);
    }

    public boolean hasFunction(String functionName) {
        String name = functionName.toLowerCase(Locale.ROOT);
        return this.userFunctions.containsKey(name) || this.dialect.getFunctions().containsKey(name);
    }
}

