/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.dialect.unique;

import java.util.Iterator;
import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.dialect.unique.UniqueDelegate;
import org.evosuite.shaded.org.hibernate.metamodel.relational.Column;
import org.evosuite.shaded.org.hibernate.metamodel.relational.Table;
import org.evosuite.shaded.org.hibernate.metamodel.relational.UniqueKey;

public class DefaultUniqueDelegate
implements UniqueDelegate {
    protected final Dialect dialect;

    public DefaultUniqueDelegate(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String getColumnDefinitionUniquenessFragment(org.evosuite.shaded.org.hibernate.mapping.Column column) {
        return "";
    }

    @Override
    public String getTableCreationUniqueConstraintsFragment(org.evosuite.shaded.org.hibernate.mapping.Table table) {
        return "";
    }

    @Override
    public String getAlterTableToAddUniqueKeyCommand(org.evosuite.shaded.org.hibernate.mapping.UniqueKey uniqueKey, String defaultCatalog, String defaultSchema) {
        String tableName = uniqueKey.getTable().getQualifiedName(this.dialect, defaultCatalog, defaultSchema);
        String constraintName = this.dialect.quote(uniqueKey.getName());
        return "alter table " + tableName + " add constraint " + constraintName + " " + this.uniqueConstraintSql(uniqueKey);
    }

    protected String uniqueConstraintSql(org.evosuite.shaded.org.hibernate.mapping.UniqueKey uniqueKey) {
        StringBuilder sb = new StringBuilder();
        sb.append(" unique (");
        Iterator<org.evosuite.shaded.org.hibernate.mapping.Column> columnIterator = uniqueKey.columnIterator();
        while (columnIterator.hasNext()) {
            org.evosuite.shaded.org.hibernate.mapping.Column column = columnIterator.next();
            sb.append(column.getQuotedName(this.dialect));
            if (uniqueKey.getColumnOrderMap().containsKey(column)) {
                sb.append(" ").append(uniqueKey.getColumnOrderMap().get(column));
            }
            if (!columnIterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.append(')').toString();
    }

    @Override
    public String getAlterTableToDropUniqueKeyCommand(org.evosuite.shaded.org.hibernate.mapping.UniqueKey uniqueKey, String defaultCatalog, String defaultSchema) {
        StringBuilder buf = new StringBuilder("alter table ");
        buf.append(uniqueKey.getTable().getQualifiedName(this.dialect, defaultCatalog, defaultSchema));
        buf.append(" drop constraint ");
        if (this.dialect.supportsIfExistsBeforeConstraintName()) {
            buf.append("if exists ");
        }
        buf.append(this.dialect.quote(uniqueKey.getName()));
        if (this.dialect.supportsIfExistsAfterConstraintName()) {
            buf.append(" if exists");
        }
        return buf.toString();
    }

    @Override
    public String getColumnDefinitionUniquenessFragment(Column column) {
        return "";
    }

    @Override
    public String getTableCreationUniqueConstraintsFragment(Table table) {
        return "";
    }

    @Override
    public String getAlterTableToAddUniqueKeyCommand(UniqueKey uniqueKey) {
        String tableName = uniqueKey.getTable().getQualifiedName(this.dialect);
        String constraintName = this.dialect.quote(uniqueKey.getName());
        return "alter table " + tableName + " add constraint " + constraintName + this.uniqueConstraintSql(uniqueKey);
    }

    protected String uniqueConstraintSql(UniqueKey uniqueKey) {
        StringBuilder sb = new StringBuilder(" unique (");
        Iterator<Column> columnIterator = uniqueKey.getColumns().iterator();
        while (columnIterator.hasNext()) {
            org.evosuite.shaded.org.hibernate.mapping.Column column = (org.evosuite.shaded.org.hibernate.mapping.Column)((Object)columnIterator.next());
            sb.append(column.getQuotedName(this.dialect));
            if (!columnIterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.append(')').toString();
    }

    @Override
    public String getAlterTableToDropUniqueKeyCommand(UniqueKey uniqueKey) {
        String tableName = uniqueKey.getTable().getQualifiedName(this.dialect);
        String constraintName = this.dialect.quote(uniqueKey.getName());
        return "alter table " + tableName + " drop constraint " + constraintName;
    }
}

