/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.engine.internal;

import java.io.Serializable;
import org.evosuite.shaded.org.hibernate.AssertionFailure;
import org.evosuite.shaded.org.hibernate.CacheMode;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.LockMode;
import org.evosuite.shaded.org.hibernate.bytecode.instrumentation.spi.LazyPropertyInitializer;
import org.evosuite.shaded.org.hibernate.cache.spi.CacheKey;
import org.evosuite.shaded.org.hibernate.cache.spi.entry.CacheEntry;
import org.evosuite.shaded.org.hibernate.engine.internal.Versioning;
import org.evosuite.shaded.org.hibernate.engine.spi.EntityEntry;
import org.evosuite.shaded.org.hibernate.engine.spi.EntityKey;
import org.evosuite.shaded.org.hibernate.engine.spi.PersistenceContext;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.Status;
import org.evosuite.shaded.org.hibernate.event.service.spi.EventListenerGroup;
import org.evosuite.shaded.org.hibernate.event.service.spi.EventListenerRegistry;
import org.evosuite.shaded.org.hibernate.event.spi.EventType;
import org.evosuite.shaded.org.hibernate.event.spi.PostLoadEvent;
import org.evosuite.shaded.org.hibernate.event.spi.PostLoadEventListener;
import org.evosuite.shaded.org.hibernate.event.spi.PreLoadEvent;
import org.evosuite.shaded.org.hibernate.event.spi.PreLoadEventListener;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.persister.entity.EntityPersister;
import org.evosuite.shaded.org.hibernate.pretty.MessageHelper;
import org.evosuite.shaded.org.hibernate.property.BackrefPropertyAccessor;
import org.evosuite.shaded.org.hibernate.proxy.HibernateProxy;
import org.evosuite.shaded.org.hibernate.type.Type;
import org.evosuite.shaded.org.hibernate.type.TypeHelper;
import org.evosuite.shaded.org.jboss.logging.Logger;

public final class TwoPhaseLoad {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, TwoPhaseLoad.class.getName());

    private TwoPhaseLoad() {
    }

    public static void postHydrate(EntityPersister persister, Serializable id, Object[] values, Object rowId, Object object, LockMode lockMode, boolean lazyPropertiesAreUnFetched, SessionImplementor session) {
        Object version = Versioning.getVersion(values, persister);
        session.getPersistenceContext().addEntry(object, Status.LOADING, values, rowId, id, version, lockMode, true, persister, false, lazyPropertiesAreUnFetched);
        if (version != null && LOG.isTraceEnabled()) {
            String versionStr = persister.isVersioned() ? persister.getVersionType().toLoggableString(version, session.getFactory()) : "null";
            LOG.tracef("Version: %s", (Object)versionStr);
        }
    }

    public static void initializeEntity(Object entity, boolean readOnly, SessionImplementor session, PreLoadEvent preLoadEvent) {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        EntityEntry entityEntry = persistenceContext.getEntry(entity);
        if (entityEntry == null) {
            throw new AssertionFailure("possible non-threadsafe access to the session");
        }
        TwoPhaseLoad.doInitializeEntity(entity, entityEntry, readOnly, session, preLoadEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doInitializeEntity(Object entity, EntityEntry entityEntry, boolean readOnly, SessionImplementor session, PreLoadEvent preLoadEvent) throws HibernateException {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        EntityPersister persister = entityEntry.getPersister();
        Serializable id = entityEntry.getId();
        Object[] hydratedState = entityEntry.getLoadedState();
        boolean debugEnabled = LOG.isDebugEnabled();
        if (debugEnabled) {
            LOG.debugf("Resolving associations for %s", (Object)MessageHelper.infoString(persister, id, session.getFactory()));
        }
        Type[] types = persister.getPropertyTypes();
        for (int i = 0; i < hydratedState.length; ++i) {
            Object value = hydratedState[i];
            if (value == LazyPropertyInitializer.UNFETCHED_PROPERTY || value == BackrefPropertyAccessor.UNKNOWN) continue;
            hydratedState[i] = types[i].resolve(value, session, entity);
        }
        if (session.isEventSource()) {
            preLoadEvent.setEntity(entity).setState(hydratedState).setId(id).setPersister(persister);
            EventListenerGroup<PreLoadEventListener> listenerGroup = session.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.PRE_LOAD);
            for (PreLoadEventListener listener : listenerGroup.listeners()) {
                listener.onPreLoad(preLoadEvent);
            }
        }
        persister.setPropertyValues(entity, hydratedState);
        SessionFactoryImplementor factory = session.getFactory();
        if (persister.hasCache() && session.getCacheMode().isPutEnabled()) {
            if (debugEnabled) {
                LOG.debugf("Adding entity to second-level cache: %s", (Object)MessageHelper.infoString(persister, id, session.getFactory()));
            }
            Object version = Versioning.getVersion(hydratedState, persister);
            CacheEntry entry = persister.buildCacheEntry(entity, hydratedState, version, session);
            CacheKey cacheKey = session.generateCacheKey(id, persister.getIdentifierType(), persister.getRootEntityName());
            if (session.getPersistenceContext().wasInsertedDuringTransaction(persister, id)) {
                persister.getCacheAccessStrategy().update(cacheKey, persister.getCacheEntryStructure().structure(entry), version, version);
            } else {
                try {
                    session.getEventListenerManager().cachePutStart();
                    boolean put = persister.getCacheAccessStrategy().putFromLoad(cacheKey, persister.getCacheEntryStructure().structure(entry), session.getTimestamp(), version, TwoPhaseLoad.useMinimalPuts(session, entityEntry));
                    if (put && factory.getStatistics().isStatisticsEnabled()) {
                        factory.getStatisticsImplementor().secondLevelCachePut(persister.getCacheAccessStrategy().getRegion().getName());
                    }
                }
                finally {
                    session.getEventListenerManager().cachePutEnd();
                }
            }
        }
        if (persister.hasNaturalIdentifier()) {
            persistenceContext.getNaturalIdHelper().cacheNaturalIdCrossReferenceFromLoad(persister, id, persistenceContext.getNaturalIdHelper().extractNaturalIdValues(hydratedState, persister));
        }
        boolean isReallyReadOnly = readOnly;
        if (!persister.isMutable()) {
            isReallyReadOnly = true;
        } else {
            Object proxy = persistenceContext.getProxy(entityEntry.getEntityKey());
            if (proxy != null) {
                isReallyReadOnly = ((HibernateProxy)proxy).getHibernateLazyInitializer().isReadOnly();
            }
        }
        if (isReallyReadOnly) {
            persistenceContext.setEntryStatus(entityEntry, Status.READ_ONLY);
        } else {
            TypeHelper.deepCopy(hydratedState, persister.getPropertyTypes(), persister.getPropertyUpdateability(), hydratedState, session);
            persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
        }
        persister.afterInitialize(entity, entityEntry.isLoadedWithLazyPropertiesUnfetched(), session);
        if (debugEnabled) {
            LOG.debugf("Done materializing entity %s", (Object)MessageHelper.infoString(persister, id, session.getFactory()));
        }
        if (factory.getStatistics().isStatisticsEnabled()) {
            factory.getStatisticsImplementor().loadEntity(persister.getEntityName());
        }
    }

    public static void postLoad(Object entity, SessionImplementor session, PostLoadEvent postLoadEvent) {
        if (session.isEventSource()) {
            PersistenceContext persistenceContext = session.getPersistenceContext();
            EntityEntry entityEntry = persistenceContext.getEntry(entity);
            postLoadEvent.setEntity(entity).setId(entityEntry.getId()).setPersister(entityEntry.getPersister());
            EventListenerGroup<PostLoadEventListener> listenerGroup = session.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.POST_LOAD);
            for (PostLoadEventListener listener : listenerGroup.listeners()) {
                listener.onPostLoad(postLoadEvent);
            }
        }
    }

    private static boolean useMinimalPuts(SessionImplementor session, EntityEntry entityEntry) {
        return session.getFactory().getSettings().isMinimalPutsEnabled() && session.getCacheMode() != CacheMode.REFRESH || entityEntry.getPersister().hasLazyProperties() && entityEntry.isLoadedWithLazyPropertiesUnfetched() && entityEntry.getPersister().isLazyPropertiesCacheable();
    }

    public static void addUninitializedEntity(EntityKey key, Object object, EntityPersister persister, LockMode lockMode, boolean lazyPropertiesAreUnFetched, SessionImplementor session) {
        session.getPersistenceContext().addEntity(object, Status.LOADING, null, key, null, lockMode, true, persister, false, lazyPropertiesAreUnFetched);
    }

    public static void addUninitializedCachedEntity(EntityKey key, Object object, EntityPersister persister, LockMode lockMode, boolean lazyPropertiesAreUnFetched, Object version, SessionImplementor session) {
        session.getPersistenceContext().addEntity(object, Status.LOADING, null, key, version, lockMode, true, persister, false, lazyPropertiesAreUnFetched);
    }
}

