/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.engine.jdbc.batch.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.evosuite.shaded.org.hibernate.engine.jdbc.batch.spi.Batch;
import org.evosuite.shaded.org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.evosuite.shaded.org.hibernate.engine.jdbc.batch.spi.BatchObserver;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.JdbcServices;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionContext;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.jboss.logging.Logger;

public abstract class AbstractBatchImpl
implements Batch {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, AbstractBatchImpl.class.getName());
    private final BatchKey key;
    private final JdbcCoordinator jdbcCoordinator;
    private final TransactionContext transactionContext;
    private final SqlStatementLogger sqlStatementLogger;
    private final SqlExceptionHelper sqlExceptionHelper;
    private LinkedHashMap<String, PreparedStatement> statements = new LinkedHashMap();
    private LinkedHashSet<BatchObserver> observers = new LinkedHashSet();

    protected AbstractBatchImpl(BatchKey key, JdbcCoordinator jdbcCoordinator) {
        if (key == null) {
            throw new IllegalArgumentException("batch key cannot be null");
        }
        if (jdbcCoordinator == null) {
            throw new IllegalArgumentException("JDBC coordinator cannot be null");
        }
        this.key = key;
        this.jdbcCoordinator = jdbcCoordinator;
        this.transactionContext = jdbcCoordinator.getTransactionCoordinator().getTransactionContext();
        JdbcServices jdbcServices = this.transactionContext.getTransactionEnvironment().getJdbcServices();
        this.sqlStatementLogger = jdbcServices.getSqlStatementLogger();
        this.sqlExceptionHelper = jdbcServices.getSqlExceptionHelper();
    }

    protected abstract void doExecuteBatch();

    public TransactionContext transactionContext() {
        return this.transactionContext;
    }

    protected SqlExceptionHelper sqlExceptionHelper() {
        return this.sqlExceptionHelper;
    }

    protected SqlStatementLogger sqlStatementLogger() {
        return this.sqlStatementLogger;
    }

    protected void abortBatch() {
        this.jdbcCoordinator.abortBatch();
    }

    protected LinkedHashMap<String, PreparedStatement> getStatements() {
        return this.statements;
    }

    @Override
    public final BatchKey getKey() {
        return this.key;
    }

    @Override
    public void addObserver(BatchObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public PreparedStatement getBatchStatement(String sql, boolean callable) {
        if (sql == null) {
            throw new IllegalArgumentException("sql must be non-null.");
        }
        PreparedStatement statement = this.statements.get(sql);
        if (statement == null) {
            statement = this.buildBatchStatement(sql, callable);
            this.statements.put(sql, statement);
        } else {
            LOG.debug("Reusing batch statement");
            this.sqlStatementLogger().logStatement(sql);
        }
        return statement;
    }

    private PreparedStatement buildBatchStatement(String sql, boolean callable) {
        return this.jdbcCoordinator.getStatementPreparer().prepareStatement(sql, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void execute() {
        this.notifyObserversExplicitExecution();
        if (this.getStatements().isEmpty()) {
            return;
        }
        try {
            this.doExecuteBatch();
        }
        finally {
            this.releaseStatements();
        }
    }

    protected void releaseStatements() {
        for (PreparedStatement statement : this.getStatements().values()) {
            this.clearBatch(statement);
            this.jdbcCoordinator.release(statement);
        }
        this.getStatements().clear();
    }

    protected void clearBatch(PreparedStatement statement) {
        try {
            statement.clearBatch();
        }
        catch (SQLException e) {
            LOG.unableToReleaseBatchStatement();
        }
    }

    protected final void notifyObserversExplicitExecution() {
        for (BatchObserver observer : this.observers) {
            observer.batchExplicitlyExecuted();
        }
    }

    protected final void notifyObserversImplicitExecution() {
        for (BatchObserver observer : this.observers) {
            observer.batchImplicitlyExecuted();
        }
    }

    @Override
    public void release() {
        if (this.getStatements() != null && !this.getStatements().isEmpty()) {
            LOG.batchContainedStatementsOnRelease();
        }
        this.releaseStatements();
        this.observers.clear();
    }
}

