/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.engine.jdbc.connections.internal;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.evosuite.shaded.org.hibernate.cfg.Environment;
import org.evosuite.shaded.org.hibernate.engine.jdbc.connections.internal.ConnectionCreator;
import org.evosuite.shaded.org.hibernate.engine.jdbc.connections.internal.ConnectionCreatorBuilder;
import org.evosuite.shaded.org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.evosuite.shaded.org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.internal.util.ReflectHelper;
import org.evosuite.shaded.org.hibernate.internal.util.config.ConfigurationHelper;
import org.evosuite.shaded.org.hibernate.service.UnknownUnwrapTypeException;
import org.evosuite.shaded.org.hibernate.service.spi.Configurable;
import org.evosuite.shaded.org.hibernate.service.spi.ServiceException;
import org.evosuite.shaded.org.hibernate.service.spi.ServiceRegistryAwareService;
import org.evosuite.shaded.org.hibernate.service.spi.ServiceRegistryImplementor;
import org.evosuite.shaded.org.hibernate.service.spi.Stoppable;

public class DriverManagerConnectionProviderImpl
implements ConnectionProvider,
Configurable,
Stoppable,
ServiceRegistryAwareService {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(DriverManagerConnectionProviderImpl.class);
    public static final String MIN_SIZE = "hibernate.connection.min_pool_size";
    public static final String INITIAL_SIZE = "hibernate.connection.initial_pool_size";
    public static final String VALIDATION_INTERVAL = "hibernate.connection.pool_validation_interval";
    private boolean active = true;
    private ConcurrentLinkedQueue<Connection> connections = new ConcurrentLinkedQueue();
    private ConnectionCreator connectionCreator;
    private ScheduledExecutorService executorService;
    private ServiceRegistryImplementor serviceRegistry;

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public void configure(Map configurationValues) {
        log.usingHibernateBuiltInConnectionPool();
        this.connectionCreator = this.buildCreator(configurationValues);
        final int minSize = ConfigurationHelper.getInt(MIN_SIZE, configurationValues, 1);
        final int maxSize = ConfigurationHelper.getInt("hibernate.connection.pool_size", configurationValues, 20);
        int initialSize = ConfigurationHelper.getInt(INITIAL_SIZE, configurationValues, minSize);
        long validationInterval = ConfigurationHelper.getLong(VALIDATION_INTERVAL, configurationValues, 30);
        log.hibernateConnectionPoolSize(maxSize, minSize);
        log.debugf("Initializing Connection pool with %s Connections", (Object)initialSize);
        for (int i = 0; i < initialSize; ++i) {
            this.connections.add(this.connectionCreator.createConnection());
        }
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.executorService.scheduleWithFixedDelay(new Runnable(){
            private boolean primed;

            @Override
            public void run() {
                block6: {
                    int size;
                    block5: {
                        size = DriverManagerConnectionProviderImpl.this.connections.size();
                        if (!this.primed && size >= minSize) {
                            log.debug("Connection pool now considered primed; min-size will be maintained");
                            this.primed = true;
                        }
                        if (size >= minSize || !this.primed) break block5;
                        int numberToBeAdded = minSize - size;
                        log.debugf("Adding %s Connections to the pool", (Object)numberToBeAdded);
                        for (int i = 0; i < numberToBeAdded; ++i) {
                            DriverManagerConnectionProviderImpl.this.connections.add(DriverManagerConnectionProviderImpl.this.connectionCreator.createConnection());
                        }
                        break block6;
                    }
                    if (size <= maxSize) break block6;
                    int numberToBeRemoved = size - maxSize;
                    log.debugf("Removing %s Connections from the pool", (Object)numberToBeRemoved);
                    for (int i = 0; i < numberToBeRemoved; ++i) {
                        Connection connection = (Connection)DriverManagerConnectionProviderImpl.this.connections.poll();
                        try {
                            connection.close();
                            continue;
                        }
                        catch (SQLException e) {
                            log.unableToCloseConnection(e);
                        }
                    }
                }
            }
        }, validationInterval, validationInterval, TimeUnit.SECONDS);
    }

    private ConnectionCreator buildCreator(Map configurationValues) {
        ConnectionCreatorBuilder connectionCreatorBuilder = new ConnectionCreatorBuilder(this.serviceRegistry);
        String driverClassName = (String)configurationValues.get("hibernate.connection.driver_class");
        connectionCreatorBuilder.setDriver(this.loadDriverIfPossible(driverClassName));
        String url = (String)configurationValues.get("hibernate.connection.url");
        if (url == null) {
            String msg = log.jdbcUrlNotSpecified("hibernate.connection.url");
            log.error(msg);
            throw new HibernateException(msg);
        }
        connectionCreatorBuilder.setUrl(url);
        log.usingDriver(driverClassName, url);
        Properties connectionProps = ConnectionProviderInitiator.getConnectionProperties(configurationValues);
        if (log.isDebugEnabled()) {
            log.connectionProperties(connectionProps);
        } else {
            log.connectionProperties(ConfigurationHelper.maskOut(connectionProps, "password"));
        }
        connectionCreatorBuilder.setConnectionProps(connectionProps);
        boolean autoCommit = ConfigurationHelper.getBoolean("hibernate.connection.autocommit", configurationValues, false);
        log.autoCommitMode(autoCommit);
        connectionCreatorBuilder.setAutoCommit(autoCommit);
        Integer isolation = ConfigurationHelper.getInteger("hibernate.connection.isolation", configurationValues);
        if (isolation != null) {
            log.jdbcIsolationLevel(Environment.isolationLevelToString(isolation));
        }
        connectionCreatorBuilder.setIsolation(isolation);
        return connectionCreatorBuilder.build();
    }

    private Driver loadDriverIfPossible(String driverClassName) {
        if (driverClassName == null) {
            log.debug("No driver class specified");
            return null;
        }
        if (this.serviceRegistry != null) {
            ClassLoaderService classLoaderService = this.serviceRegistry.getService(ClassLoaderService.class);
            Class driverClass = classLoaderService.classForName(driverClassName);
            try {
                return (Driver)driverClass.newInstance();
            }
            catch (Exception e) {
                throw new ServiceException("Specified JDBC Driver " + driverClassName + " could not be loaded", e);
            }
        }
        try {
            return (Driver)Class.forName(driverClassName).newInstance();
        }
        catch (Exception e1) {
            try {
                return (Driver)ReflectHelper.classForName(driverClassName).newInstance();
            }
            catch (Exception e2) {
                throw new ServiceException("Specified JDBC Driver " + driverClassName + " could not be loaded", e2);
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (!this.active) {
            throw new HibernateException("Connection pool is no longer active");
        }
        Connection connection = this.connections.poll();
        if (connection == null) {
            connection = this.connectionCreator.createConnection();
        }
        return connection;
    }

    @Override
    public void closeConnection(Connection conn) throws SQLException {
        if (conn == null) {
            return;
        }
        this.connections.offer(conn);
    }

    @Override
    public boolean supportsAggressiveRelease() {
        return false;
    }

    @Override
    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProvider.class.equals((Object)unwrapType) || DriverManagerConnectionProviderImpl.class.isAssignableFrom(unwrapType);
    }

    @Override
    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || DriverManagerConnectionProviderImpl.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    @Override
    public void stop() {
        if (!this.active) {
            return;
        }
        log.cleaningUpConnectionPool(this.connectionCreator.getUrl());
        this.active = false;
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.executorService = null;
        for (Connection connection : this.connections) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                log.unableToClosePooledConnection(e);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.active) {
            this.stop();
        }
        super.finalize();
    }
}

