/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.engine.jdbc.dialect.internal;

import java.util.Map;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.annotations.common.util.StringHelper;
import org.evosuite.shaded.org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.evosuite.shaded.org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.evosuite.shaded.org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfoSource;
import org.evosuite.shaded.org.hibernate.engine.jdbc.dialect.spi.DialectResolver;
import org.evosuite.shaded.org.hibernate.service.spi.ServiceRegistryAwareService;
import org.evosuite.shaded.org.hibernate.service.spi.ServiceRegistryImplementor;

public class DialectFactoryImpl
implements DialectFactory,
ServiceRegistryAwareService {
    private StrategySelector strategySelector;
    private DialectResolver dialectResolver;

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.strategySelector = serviceRegistry.getService(StrategySelector.class);
        this.dialectResolver = serviceRegistry.getService(DialectResolver.class);
    }

    public void setDialectResolver(DialectResolver dialectResolver) {
        this.dialectResolver = dialectResolver;
    }

    @Override
    public Dialect buildDialect(Map configValues, DialectResolutionInfoSource resolutionInfoSource) throws HibernateException {
        String dialectName = (String)configValues.get("hibernate.dialect");
        if (!StringHelper.isEmpty(dialectName)) {
            return this.constructDialect(dialectName);
        }
        return this.determineDialect(resolutionInfoSource);
    }

    private Dialect constructDialect(String dialectName) {
        try {
            Dialect dialect = this.strategySelector.resolveStrategy(Dialect.class, dialectName);
            if (dialect == null) {
                throw new HibernateException("Unable to construct requested dialect [" + dialectName + "]");
            }
            return dialect;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HibernateException("Unable to construct requested dialect [" + dialectName + "]", e);
        }
    }

    private Dialect determineDialect(DialectResolutionInfoSource resolutionInfoSource) {
        if (resolutionInfoSource == null) {
            throw new HibernateException("Access to DialectResolutionInfo cannot be null when 'hibernate.dialect' not set");
        }
        DialectResolutionInfo info = resolutionInfoSource.getDialectResolutionInfo();
        Dialect dialect = this.dialectResolver.resolveDialect(info);
        if (dialect == null) {
            throw new HibernateException("Unable to determine Dialect to use [name=" + info.getDatabaseName() + ", majorVersion=" + info.getDatabaseMajorVersion() + "]; user must register resolver or explicitly set 'hibernate.dialect'");
        }
        return dialect;
    }
}

