/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.engine.jdbc.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.shaded.org.hibernate.ConnectionReleaseMode;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.TransactionException;
import org.evosuite.shaded.org.hibernate.engine.jdbc.batch.spi.Batch;
import org.evosuite.shaded.org.hibernate.engine.jdbc.batch.spi.BatchBuilder;
import org.evosuite.shaded.org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.evosuite.shaded.org.hibernate.engine.jdbc.internal.LogicalConnectionImpl;
import org.evosuite.shaded.org.hibernate.engine.jdbc.internal.ResultSetReturnImpl;
import org.evosuite.shaded.org.hibernate.engine.jdbc.internal.StatementPreparerImpl;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.InvalidatableWrapper;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.JdbcWrapper;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.LogicalConnectionImplementor;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.ResultSetReturn;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.transaction.internal.TransactionCoordinatorImpl;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionContext;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionEnvironment;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.jdbc.WorkExecutor;
import org.evosuite.shaded.org.hibernate.jdbc.WorkExecutorVisitable;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class JdbcCoordinatorImpl
implements JdbcCoordinator {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, JdbcCoordinatorImpl.class.getName());
    private transient TransactionCoordinator transactionCoordinator;
    private final transient LogicalConnectionImpl logicalConnection;
    private transient Batch currentBatch;
    private transient long transactionTimeOutInstant = -1L;
    private static final Set<ResultSet> EMPTY_RESULTSET = Collections.emptySet();
    private final HashMap<Statement, Set<ResultSet>> xref = new HashMap();
    private final Set<ResultSet> unassociatedResultSets = new HashSet<ResultSet>();
    private final transient SqlExceptionHelper exceptionHelper;
    private Statement lastQuery;
    private boolean releasesEnabled = true;
    private int flushDepth;
    private transient StatementPreparer statementPreparer;
    private transient ResultSetReturn resultSetExtractor;

    public JdbcCoordinatorImpl(Connection userSuppliedConnection, TransactionCoordinator transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
        this.logicalConnection = new LogicalConnectionImpl(userSuppliedConnection, transactionCoordinator.getTransactionContext().getConnectionReleaseMode(), transactionCoordinator.getTransactionContext().getTransactionEnvironment().getJdbcServices(), transactionCoordinator.getTransactionContext().getJdbcConnectionAccess());
        this.exceptionHelper = this.logicalConnection.getJdbcServices().getSqlExceptionHelper();
    }

    public JdbcCoordinatorImpl(LogicalConnectionImpl logicalConnection, TransactionCoordinator transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
        this.logicalConnection = logicalConnection;
        this.exceptionHelper = logicalConnection.getJdbcServices().getSqlExceptionHelper();
    }

    private JdbcCoordinatorImpl(LogicalConnectionImpl logicalConnection) {
        this.logicalConnection = logicalConnection;
        this.exceptionHelper = logicalConnection.getJdbcServices().getSqlExceptionHelper();
    }

    @Override
    public TransactionCoordinator getTransactionCoordinator() {
        return this.transactionCoordinator;
    }

    @Override
    public LogicalConnectionImplementor getLogicalConnection() {
        return this.logicalConnection;
    }

    protected TransactionEnvironment transactionEnvironment() {
        return this.getTransactionCoordinator().getTransactionContext().getTransactionEnvironment();
    }

    protected SessionFactoryImplementor sessionFactory() {
        return this.transactionEnvironment().getSessionFactory();
    }

    protected BatchBuilder batchBuilder() {
        return this.sessionFactory().getServiceRegistry().getService(BatchBuilder.class);
    }

    public SqlExceptionHelper sqlExceptionHelper() {
        return this.exceptionHelper;
    }

    @Override
    public void flushBeginning() {
        if (this.flushDepth == 0) {
            this.releasesEnabled = false;
        }
        ++this.flushDepth;
    }

    @Override
    public void flushEnding() {
        --this.flushDepth;
        if (this.flushDepth < 0) {
            throw new HibernateException("Mismatched flush handling");
        }
        if (this.flushDepth == 0) {
            this.releasesEnabled = true;
        }
        this.afterStatementExecution();
    }

    @Override
    public Connection close() {
        LOG.tracev("Closing JDBC container [{0}]", (Object)this);
        if (this.currentBatch != null) {
            LOG.closingUnreleasedBatch();
            this.currentBatch.release();
        }
        this.cleanup();
        return this.logicalConnection.close();
    }

    @Override
    public Batch getBatch(BatchKey key) {
        if (this.currentBatch != null) {
            if (this.currentBatch.getKey().equals(key)) {
                return this.currentBatch;
            }
            this.currentBatch.execute();
            this.currentBatch.release();
        }
        this.currentBatch = this.batchBuilder().buildBatch(key, this);
        return this.currentBatch;
    }

    @Override
    public void executeBatch() {
        if (this.currentBatch != null) {
            this.currentBatch.execute();
            this.currentBatch.release();
        }
    }

    @Override
    public void abortBatch() {
        if (this.currentBatch != null) {
            this.currentBatch.release();
        }
    }

    @Override
    public StatementPreparer getStatementPreparer() {
        if (this.statementPreparer == null) {
            this.statementPreparer = new StatementPreparerImpl(this);
        }
        return this.statementPreparer;
    }

    @Override
    public ResultSetReturn getResultSetReturn() {
        if (this.resultSetExtractor == null) {
            this.resultSetExtractor = new ResultSetReturnImpl(this);
        }
        return this.resultSetExtractor;
    }

    @Override
    public void setTransactionTimeOut(int seconds) {
        this.transactionTimeOutInstant = System.currentTimeMillis() + (long)(seconds * 1000);
    }

    @Override
    public int determineRemainingTransactionTimeOutPeriod() {
        if (this.transactionTimeOutInstant < 0L) {
            return -1;
        }
        int secondsRemaining = (int)((this.transactionTimeOutInstant - System.currentTimeMillis()) / 1000L);
        if (secondsRemaining <= 0) {
            throw new TransactionException("transaction timeout expired");
        }
        return secondsRemaining;
    }

    @Override
    public void afterStatementExecution() {
        LOG.tracev("Starting after statement execution processing [{0}]", (Object)this.connectionReleaseMode());
        if (this.connectionReleaseMode() == ConnectionReleaseMode.AFTER_STATEMENT) {
            if (!this.releasesEnabled) {
                LOG.debug("Skipping aggressive release due to manual disabling");
                return;
            }
            if (this.hasRegisteredResources()) {
                LOG.debug("Skipping aggressive release due to registered resources");
                return;
            }
            this.getLogicalConnection().releaseConnection();
        }
    }

    @Override
    public void afterTransaction() {
        this.transactionTimeOutInstant = -1L;
        if (this.connectionReleaseMode() == ConnectionReleaseMode.AFTER_STATEMENT || this.connectionReleaseMode() == ConnectionReleaseMode.AFTER_TRANSACTION) {
            if (this.hasRegisteredResources()) {
                LOG.forcingContainerResourceCleanup();
                this.releaseResources();
            }
            this.getLogicalConnection().aggressiveRelease();
        }
    }

    private ConnectionReleaseMode connectionReleaseMode() {
        return this.getLogicalConnection().getConnectionReleaseMode();
    }

    @Override
    public <T> T coordinateWork(WorkExecutorVisitable<T> work) {
        Connection connection = this.getLogicalConnection().getConnection();
        try {
            T result = work.accept(new WorkExecutor(), connection);
            this.afterStatementExecution();
            return result;
        }
        catch (SQLException e) {
            throw this.sqlExceptionHelper().convert(e, "error executing work");
        }
    }

    @Override
    public boolean isReadyForSerialization() {
        return this.getLogicalConnection().isUserSuppliedConnection() ? !this.getLogicalConnection().isPhysicallyConnected() : !this.hasRegisteredResources();
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        if (!this.isReadyForSerialization()) {
            throw new HibernateException("Cannot serialize Session while connected");
        }
        this.logicalConnection.serialize(oos);
    }

    public static JdbcCoordinatorImpl deserialize(ObjectInputStream ois, TransactionContext transactionContext) throws IOException, ClassNotFoundException {
        return new JdbcCoordinatorImpl(LogicalConnectionImpl.deserialize(ois, transactionContext));
    }

    public void afterDeserialize(TransactionCoordinatorImpl transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
    }

    @Override
    public void register(Statement statement) {
        LOG.tracev("Registering statement [{0}]", (Object)statement);
        Set<ResultSet> previousValue = this.xref.put(statement, EMPTY_RESULTSET);
        if (previousValue != null) {
            this.xref.put(statement, previousValue);
            throw new HibernateException("statement already registered with JDBCContainer");
        }
    }

    @Override
    public void registerLastQuery(Statement statement) {
        LOG.tracev("Registering last query statement [{0}]", (Object)statement);
        if (statement instanceof JdbcWrapper) {
            JdbcWrapper wrapper = (JdbcWrapper)((Object)statement);
            this.registerLastQuery((Statement)wrapper.getWrappedObject());
            return;
        }
        this.lastQuery = statement;
    }

    @Override
    public void cancelLastQuery() {
        try {
            if (this.lastQuery != null) {
                this.lastQuery.cancel();
            }
        }
        catch (SQLException sqle) {
            throw this.exceptionHelper.convert(sqle, "Cannot cancel query");
        }
        finally {
            this.lastQuery = null;
        }
    }

    @Override
    public void release(Statement statement) {
        LOG.tracev("Releasing statement [{0}]", (Object)statement);
        Set<ResultSet> resultSets = this.xref.get(statement);
        if (resultSets != null) {
            for (ResultSet resultSet : resultSets) {
                this.close(resultSet);
            }
            resultSets.clear();
        }
        this.xref.remove(statement);
        this.close(statement);
        this.afterStatementExecution();
    }

    @Override
    public void register(ResultSet resultSet, Statement statement) {
        if (statement == null) {
            try {
                statement = resultSet.getStatement();
            }
            catch (SQLException e) {
                throw this.exceptionHelper.convert(e, "unable to access statement from resultset");
            }
        }
        if (statement != null) {
            LOG.tracev("Registering result set [{0}]", (Object)resultSet);
            Set<ResultSet> resultSets = this.xref.get(statement);
            if (resultSets == null) {
                LOG.unregisteredStatement();
            }
            if (resultSets == null || resultSets == EMPTY_RESULTSET) {
                resultSets = new HashSet<ResultSet>();
                this.xref.put(statement, resultSets);
            }
            resultSets.add(resultSet);
        } else {
            this.unassociatedResultSets.add(resultSet);
        }
    }

    @Override
    public void release(ResultSet resultSet, Statement statement) {
        LOG.tracev("Releasing result set [{0}]", (Object)resultSet);
        if (statement == null) {
            try {
                statement = resultSet.getStatement();
            }
            catch (SQLException e) {
                throw this.exceptionHelper.convert(e, "unable to access statement from resultset");
            }
        }
        if (statement != null) {
            Set<ResultSet> resultSets = this.xref.get(statement);
            if (resultSets == null) {
                LOG.unregisteredStatement();
            } else {
                resultSets.remove(resultSet);
                if (resultSets.isEmpty()) {
                    this.xref.remove(statement);
                }
            }
        } else {
            boolean removed = this.unassociatedResultSets.remove(resultSet);
            if (!removed) {
                LOG.unregisteredResultSetWithoutStatement();
            }
        }
        this.close(resultSet);
    }

    @Override
    public boolean hasRegisteredResources() {
        return !this.xref.isEmpty() || !this.unassociatedResultSets.isEmpty();
    }

    @Override
    public void releaseResources() {
        LOG.tracev("Releasing JDBC container resources [{0}]", (Object)this);
        this.cleanup();
    }

    @Override
    public void enableReleases() {
        this.releasesEnabled = true;
    }

    @Override
    public void disableReleases() {
        this.releasesEnabled = false;
    }

    private void cleanup() {
        for (Map.Entry<Statement, Set<ResultSet>> entry : this.xref.entrySet()) {
            this.closeAll(entry.getValue());
            this.close(entry.getKey());
        }
        this.xref.clear();
        this.closeAll(this.unassociatedResultSets);
    }

    protected void closeAll(Set<ResultSet> resultSets) {
        for (ResultSet resultSet : resultSets) {
            this.close(resultSet);
        }
        resultSets.clear();
    }

    protected void close(Statement statement) {
        LOG.tracev("Closing prepared statement [{0}]", (Object)statement);
        this.sqlExceptionHelper().logAndClearWarnings(statement);
        if (statement instanceof InvalidatableWrapper) {
            InvalidatableWrapper wrapper = (InvalidatableWrapper)((Object)statement);
            this.close((Statement)wrapper.getWrappedObject());
            wrapper.invalidate();
            return;
        }
        try {
            try {
                if (statement.getMaxRows() != 0) {
                    statement.setMaxRows(0);
                }
                if (statement.getQueryTimeout() != 0) {
                    statement.setQueryTimeout(0);
                }
            }
            catch (SQLException sqle) {
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("Exception clearing maxRows/queryTimeout [%s]", (Object)sqle.getMessage());
                }
                return;
            }
            statement.close();
            if (this.lastQuery == statement) {
                this.lastQuery = null;
            }
        }
        catch (SQLException e) {
            LOG.debugf("Unable to release JDBC statement [%s]", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOG.debugf("Unable to release JDBC statement [%s]", (Object)e.getMessage());
        }
    }

    protected void close(ResultSet resultSet) {
        LOG.tracev("Closing result set [{0}]", (Object)resultSet);
        if (resultSet instanceof InvalidatableWrapper) {
            InvalidatableWrapper wrapper = (InvalidatableWrapper)((Object)resultSet);
            this.close((ResultSet)wrapper.getWrappedObject());
            wrapper.invalidate();
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException e) {
            LOG.debugf("Unable to release JDBC result set [%s]", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOG.debugf("Unable to release JDBC result set [%s]", (Object)e.getMessage());
        }
    }
}

