/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.engine.query.spi;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.QueryException;
import org.evosuite.shaded.org.hibernate.action.internal.BulkOperationCleanupAction;
import org.evosuite.shaded.org.hibernate.engine.spi.QueryParameters;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.TypedValue;
import org.evosuite.shaded.org.hibernate.event.spi.EventSource;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.internal.util.collections.ArrayHelper;
import org.evosuite.shaded.org.hibernate.loader.custom.CustomQuery;
import org.evosuite.shaded.org.hibernate.type.Type;

public class NativeSQLQueryPlan
implements Serializable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(NativeSQLQueryPlan.class);
    private final String sourceQuery;
    private final CustomQuery customQuery;

    public NativeSQLQueryPlan(String sourceQuery, CustomQuery customQuery) {
        this.sourceQuery = sourceQuery;
        this.customQuery = customQuery;
    }

    public String getSourceQuery() {
        return this.sourceQuery;
    }

    public CustomQuery getCustomQuery() {
        return this.customQuery;
    }

    private int[] getNamedParameterLocs(String name) throws QueryException {
        Object loc = this.customQuery.getNamedParameterBindPoints().get(name);
        if (loc == null) {
            throw new QueryException("Named parameter does not appear in Query: " + name, this.customQuery.getSQL());
        }
        if (loc instanceof Integer) {
            return new int[]{(Integer)loc};
        }
        return ArrayHelper.toIntArray((List)loc);
    }

    private int bindPositionalParameters(PreparedStatement st, QueryParameters queryParameters, int start, SessionImplementor session) throws SQLException {
        Object[] values = queryParameters.getFilteredPositionalParameterValues();
        Type[] types = queryParameters.getFilteredPositionalParameterTypes();
        int span = 0;
        for (int i = 0; i < values.length; ++i) {
            types[i].nullSafeSet(st, values[i], start + span, session);
            span += types[i].getColumnSpan(session.getFactory());
        }
        return span;
    }

    private int bindNamedParameters(PreparedStatement ps, Map namedParams, int start, SessionImplementor session) throws SQLException {
        if (namedParams != null) {
            Iterator iter = namedParams.entrySet().iterator();
            int result = 0;
            while (iter.hasNext()) {
                int[] locs;
                Map.Entry e = iter.next();
                String name = (String)e.getKey();
                TypedValue typedval = (TypedValue)e.getValue();
                for (int loc : locs = this.getNamedParameterLocs(name)) {
                    LOG.debugf("bindNamedParameters() %s -> %s [%s]", typedval.getValue(), (Object)name, (Object)(loc + start));
                    typedval.getType().nullSafeSet(ps, typedval.getValue(), loc + start, session);
                }
                result += locs.length;
            }
            return result;
        }
        return 0;
    }

    protected void coordinateSharedCacheCleanup(SessionImplementor session) {
        BulkOperationCleanupAction action = new BulkOperationCleanupAction(session, this.getCustomQuery().getQuerySpaces());
        if (session.isEventSource()) {
            ((EventSource)session).getActionQueue().addAction(action);
        } else {
            action.getAfterTransactionCompletionProcess().doAfterTransactionCompletion(true, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int performExecuteUpdate(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        this.coordinateSharedCacheCleanup(session);
        if (queryParameters.isCallable()) {
            throw new IllegalArgumentException("callable not yet supported for native queries");
        }
        int result = 0;
        try {
            queryParameters.processFilters(this.customQuery.getSQL(), session);
            String sql = queryParameters.getFilteredSQL();
            PreparedStatement ps = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(sql, false);
            try {
                int col = 1;
                col += this.bindPositionalParameters(ps, queryParameters, col, session);
                col += this.bindNamedParameters(ps, queryParameters.getNamedParameters(), col, session);
                result = session.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(ps);
            }
            finally {
                if (ps != null) {
                    session.getTransactionCoordinator().getJdbcCoordinator().release(ps);
                }
            }
        }
        catch (SQLException sqle) {
            throw session.getFactory().getSQLExceptionHelper().convert(sqle, "could not execute native bulk manipulation query", this.sourceQuery);
        }
        return result;
    }
}

