/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.engine.transaction.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.shaded.org.hibernate.ConnectionReleaseMode;
import org.evosuite.shaded.org.hibernate.ResourceClosedException;
import org.evosuite.shaded.org.hibernate.engine.jdbc.internal.JdbcCoordinatorImpl;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.transaction.internal.SynchronizationRegistryImpl;
import org.evosuite.shaded.org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.evosuite.shaded.org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.JoinStatus;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.SynchronizationRegistry;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionContext;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionEnvironment;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionFactory;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionObserver;
import org.evosuite.shaded.org.hibernate.engine.transaction.synchronization.internal.RegisteredSynchronization;
import org.evosuite.shaded.org.hibernate.engine.transaction.synchronization.internal.SynchronizationCallbackCoordinatorNonTrackingImpl;
import org.evosuite.shaded.org.hibernate.engine.transaction.synchronization.internal.SynchronizationCallbackCoordinatorTrackingImpl;
import org.evosuite.shaded.org.hibernate.engine.transaction.synchronization.spi.SynchronizationCallbackCoordinator;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.internal.util.collections.CollectionHelper;

public final class TransactionCoordinatorImpl
implements TransactionCoordinator {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(TransactionCoordinatorImpl.class);
    private final transient TransactionContext transactionContext;
    private final transient JdbcCoordinatorImpl jdbcCoordinator;
    private final transient TransactionFactory transactionFactory;
    private final transient TransactionEnvironment transactionEnvironment;
    private final transient List<TransactionObserver> observers;
    private final transient SynchronizationRegistryImpl synchronizationRegistry;
    private transient TransactionImplementor currentHibernateTransaction;
    private transient SynchronizationCallbackCoordinator callbackCoordinator;
    private transient boolean open = true;
    private transient boolean synchronizationRegistered;
    private transient boolean ownershipTaken;
    private transient boolean isDebugging = LOG.isDebugEnabled();
    private transient boolean isTracing = LOG.isTraceEnabled();

    public TransactionCoordinatorImpl(Connection userSuppliedConnection, TransactionContext transactionContext) {
        boolean registerSynchronization;
        this.transactionContext = transactionContext;
        this.jdbcCoordinator = new JdbcCoordinatorImpl(userSuppliedConnection, (TransactionCoordinator)this);
        this.transactionEnvironment = transactionContext.getTransactionEnvironment();
        this.transactionFactory = this.transactionEnvironment.getTransactionFactory();
        this.observers = new ArrayList<TransactionObserver>();
        this.synchronizationRegistry = new SynchronizationRegistryImpl();
        this.reset();
        boolean bl = registerSynchronization = transactionContext.isAutoCloseSessionEnabled() || transactionContext.isFlushBeforeCompletionEnabled() || transactionContext.getConnectionReleaseMode() == ConnectionReleaseMode.AFTER_TRANSACTION;
        if (registerSynchronization) {
            this.pulse();
        }
    }

    public TransactionCoordinatorImpl(TransactionContext transactionContext, JdbcCoordinatorImpl jdbcCoordinator, List<TransactionObserver> observers) {
        this.transactionContext = transactionContext;
        this.jdbcCoordinator = jdbcCoordinator;
        this.transactionEnvironment = transactionContext.getTransactionEnvironment();
        this.transactionFactory = this.transactionEnvironment.getTransactionFactory();
        this.observers = observers;
        this.synchronizationRegistry = new SynchronizationRegistryImpl();
        this.reset();
    }

    public void reset() {
        this.synchronizationRegistered = false;
        this.ownershipTaken = false;
        if (this.currentHibernateTransaction != null) {
            this.currentHibernateTransaction.invalidate();
        }
        this.currentHibernateTransaction = this.transactionFactory().createTransaction(this);
        if (this.transactionContext.shouldAutoJoinTransaction()) {
            this.currentHibernateTransaction.markForJoin();
            this.currentHibernateTransaction.join();
        }
        this.synchronizationRegistry.clearSynchronizations();
    }

    @Override
    public void afterTransaction(TransactionImplementor hibernateTransaction, int status) {
        if (this.isTracing) {
            LOG.trace("after transaction completion");
        }
        boolean success = JtaStatusHelper.isCommitted(status);
        if (this.sessionFactory().getStatistics().isStatisticsEnabled()) {
            this.transactionEnvironment.getStatisticsImplementor().endTransaction(success);
        }
        this.getJdbcCoordinator().afterTransaction();
        this.getTransactionContext().afterTransactionCompletion(hibernateTransaction, success);
        this.sendAfterTransactionCompletionNotifications(hibernateTransaction, status);
        this.reset();
    }

    private SessionFactoryImplementor sessionFactory() {
        return this.transactionEnvironment.getSessionFactory();
    }

    @Override
    public boolean isSynchronizationRegistered() {
        return this.synchronizationRegistered;
    }

    @Override
    public boolean isTransactionInProgress() {
        return this.open && this.getTransaction().isActive() && this.getTransaction().getJoinStatus() == JoinStatus.JOINED;
    }

    @Override
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    public JdbcCoordinator getJdbcCoordinator() {
        return this.jdbcCoordinator;
    }

    private TransactionFactory transactionFactory() {
        return this.transactionFactory;
    }

    private TransactionEnvironment getTransactionEnvironment() {
        return this.transactionEnvironment;
    }

    @Override
    public TransactionImplementor getTransaction() {
        if (!this.open) {
            throw new ResourceClosedException("This TransactionCoordinator has been closed");
        }
        this.pulse();
        return this.currentHibernateTransaction;
    }

    @Override
    public void afterNonTransactionalQuery(boolean success) {
        boolean isAutocommit = this.getJdbcCoordinator().getLogicalConnection().isAutoCommit();
        this.getJdbcCoordinator().afterTransaction();
        if (isAutocommit) {
            for (TransactionObserver observer : this.observers) {
                observer.afterCompletion(success, this.getTransaction());
            }
        }
    }

    @Override
    public void resetJoinStatus() {
        this.getTransaction().resetJoinStatus();
    }

    private void attemptToRegisterJtaSync() {
        if (this.synchronizationRegistered) {
            return;
        }
        JtaPlatform jtaPlatform = this.getTransactionEnvironment().getJtaPlatform();
        if (jtaPlatform == null) {
            return;
        }
        if (this.currentHibernateTransaction.isInitiator()) {
            return;
        }
        JoinStatus joinStatus = this.currentHibernateTransaction.getJoinStatus();
        if (joinStatus != JoinStatus.JOINED && !this.transactionContext.shouldAutoJoinTransaction() && joinStatus != JoinStatus.MARKED_FOR_JOINED) {
            if (this.isDebugging) {
                LOG.debug("Skipping JTA sync registration due to auto join checking");
            }
            return;
        }
        if (!jtaPlatform.canRegisterSynchronization()) {
            if (this.isTracing) {
                LOG.trace("registered JTA platform says we cannot currently register synchronization; skipping");
            }
            return;
        }
        if (!this.transactionFactory().isJoinableJtaTransaction(this, this.currentHibernateTransaction)) {
            if (this.isTracing) {
                LOG.trace("TransactionFactory reported no JTA transaction to join; skipping Synchronization registration");
            }
            return;
        }
        jtaPlatform.registerSynchronization(new RegisteredSynchronization(this.getSynchronizationCallbackCoordinator()));
        this.getSynchronizationCallbackCoordinator().synchronizationRegistered();
        this.synchronizationRegistered = true;
        if (this.isDebugging) {
            LOG.debug("successfully registered Synchronization");
        }
    }

    @Override
    public SynchronizationCallbackCoordinator getSynchronizationCallbackCoordinator() {
        if (this.callbackCoordinator == null) {
            this.callbackCoordinator = this.transactionEnvironment.getSessionFactory().getSettings().isJtaTrackByThread() ? new SynchronizationCallbackCoordinatorTrackingImpl(this) : new SynchronizationCallbackCoordinatorNonTrackingImpl(this);
        }
        return this.callbackCoordinator;
    }

    @Override
    public void pulse() {
        if (this.transactionFactory().compatibleWithJtaSynchronization()) {
            this.attemptToRegisterJtaSync();
        }
    }

    @Override
    public Connection close() {
        this.open = false;
        this.reset();
        this.observers.clear();
        return this.jdbcCoordinator.close();
    }

    @Override
    public SynchronizationRegistry getSynchronizationRegistry() {
        return this.synchronizationRegistry;
    }

    @Override
    public void addObserver(TransactionObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(TransactionObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public boolean isTransactionJoinable() {
        return this.transactionFactory().isJoinableJtaTransaction(this, this.currentHibernateTransaction);
    }

    @Override
    public boolean isTransactionJoined() {
        return this.currentHibernateTransaction != null && this.currentHibernateTransaction.getJoinStatus() == JoinStatus.JOINED;
    }

    @Override
    public void setRollbackOnly() {
        this.getTransaction().markRollbackOnly();
    }

    @Override
    public boolean takeOwnership() {
        if (this.ownershipTaken) {
            return false;
        }
        this.ownershipTaken = true;
        return true;
    }

    @Override
    public void sendAfterTransactionBeginNotifications(TransactionImplementor hibernateTransaction) {
        for (TransactionObserver observer : this.observers) {
            observer.afterBegin(this.currentHibernateTransaction);
        }
    }

    @Override
    public void sendBeforeTransactionCompletionNotifications(TransactionImplementor hibernateTransaction) {
        this.synchronizationRegistry.notifySynchronizationsBeforeTransactionCompletion();
        for (TransactionObserver observer : this.observers) {
            observer.beforeCompletion(hibernateTransaction);
        }
    }

    @Override
    public void sendAfterTransactionCompletionNotifications(TransactionImplementor hibernateTransaction, int status) {
        boolean successful = JtaStatusHelper.isCommitted(status);
        for (TransactionObserver observer : new ArrayList<TransactionObserver>(this.observers)) {
            observer.afterCompletion(successful, hibernateTransaction);
        }
        this.synchronizationRegistry.notifySynchronizationsAfterTransactionCompletion(status);
    }

    @Override
    public boolean isActive() {
        return !this.sessionFactory().isClosed();
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        this.jdbcCoordinator.serialize(oos);
        oos.writeInt(this.observers.size());
        for (TransactionObserver observer : this.observers) {
            oos.writeObject(observer);
        }
    }

    public static TransactionCoordinatorImpl deserialize(ObjectInputStream ois, TransactionContext transactionContext) throws ClassNotFoundException, IOException {
        JdbcCoordinatorImpl jdbcCoordinator = JdbcCoordinatorImpl.deserialize(ois, transactionContext);
        int observerCount = ois.readInt();
        List<TransactionObserver> observers = CollectionHelper.arrayList(observerCount);
        for (int i = 0; i < observerCount; ++i) {
            observers.add((TransactionObserver)ois.readObject());
        }
        TransactionCoordinatorImpl transactionCoordinator = new TransactionCoordinatorImpl(transactionContext, jdbcCoordinator, observers);
        jdbcCoordinator.afterDeserialize(transactionCoordinator);
        return transactionCoordinator;
    }
}

