/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.engine.transaction.internal.jta;

import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.evosuite.shaded.org.hibernate.TransactionException;
import org.evosuite.shaded.org.hibernate.engine.transaction.internal.jta.JtaIsolationDelegate;
import org.evosuite.shaded.org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.AbstractTransactionImpl;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.JoinStatus;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionCoordinator;

public class CMTTransaction
extends AbstractTransactionImpl {
    private JoinStatus joinStatus = JoinStatus.NOT_JOINED;

    protected CMTTransaction(TransactionCoordinator transactionCoordinator) {
        super(transactionCoordinator);
    }

    protected TransactionManager transactionManager() {
        return this.jtaPlatform().retrieveTransactionManager();
    }

    private TransactionManager getTransactionManager() {
        return this.transactionManager();
    }

    @Override
    protected void doBegin() {
        this.transactionCoordinator().pulse();
    }

    @Override
    protected void afterTransactionBegin() {
        if (!this.transactionCoordinator().isSynchronizationRegistered()) {
            throw new TransactionException("Could not register synchronization for container transaction");
        }
        this.transactionCoordinator().sendAfterTransactionBeginNotifications(this);
        this.transactionCoordinator().getTransactionContext().afterTransactionBegin(this);
    }

    @Override
    protected void beforeTransactionCommit() {
        boolean flush;
        boolean bl = flush = !this.transactionCoordinator().getTransactionContext().isFlushModeNever() && !this.transactionCoordinator().getTransactionContext().isFlushBeforeCompletionEnabled();
        if (flush) {
            this.transactionCoordinator().getTransactionContext().managedFlush();
        }
    }

    @Override
    protected void doCommit() {
    }

    @Override
    protected void beforeTransactionRollBack() {
    }

    @Override
    protected void doRollback() {
        this.markRollbackOnly();
    }

    @Override
    protected void afterTransactionCompletion(int status) {
    }

    @Override
    protected void afterAfterCompletion() {
    }

    @Override
    public boolean isActive() throws TransactionException {
        return JtaStatusHelper.isActive(this.getTransactionManager());
    }

    @Override
    public IsolationDelegate createIsolationDelegate() {
        return new JtaIsolationDelegate(this.transactionCoordinator());
    }

    @Override
    public boolean isInitiator() {
        return false;
    }

    @Override
    public void markRollbackOnly() {
        try {
            this.getTransactionManager().setRollbackOnly();
        }
        catch (SystemException se) {
            throw new TransactionException("Could not set transaction to rollback only", se);
        }
    }

    @Override
    public void markForJoin() {
        this.joinStatus = JoinStatus.MARKED_FOR_JOINED;
    }

    @Override
    public void join() {
        if (this.joinStatus != JoinStatus.MARKED_FOR_JOINED) {
            return;
        }
        if (JtaStatusHelper.isActive(this.transactionManager())) {
            this.transactionCoordinator().pulse();
            this.joinStatus = JoinStatus.JOINED;
        } else {
            this.joinStatus = JoinStatus.NOT_JOINED;
        }
    }

    @Override
    public void resetJoinStatus() {
        this.joinStatus = JoinStatus.NOT_JOINED;
    }

    boolean isJoinable() {
        return (this.joinStatus == JoinStatus.JOINED || this.joinStatus == JoinStatus.MARKED_FOR_JOINED) && JtaStatusHelper.isActive(this.transactionManager());
    }

    @Override
    public JoinStatus getJoinStatus() {
        return this.joinStatus;
    }
}

