/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.engine.transaction.internal.jta;

import javax.transaction.SystemException;
import org.evosuite.shaded.org.hibernate.ConnectionReleaseMode;
import org.evosuite.shaded.org.hibernate.TransactionException;
import org.evosuite.shaded.org.hibernate.engine.transaction.internal.jta.CMTTransaction;
import org.evosuite.shaded.org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionFactory;

public class CMTTransactionFactory
implements TransactionFactory<CMTTransaction> {
    public static final String SHORT_NAME = "cmt";

    @Override
    public CMTTransaction createTransaction(TransactionCoordinator transactionCoordinator) {
        return new CMTTransaction(transactionCoordinator);
    }

    @Override
    public boolean canBeDriver() {
        return false;
    }

    @Override
    public ConnectionReleaseMode getDefaultReleaseMode() {
        return ConnectionReleaseMode.AFTER_STATEMENT;
    }

    @Override
    public boolean compatibleWithJtaSynchronization() {
        return true;
    }

    @Override
    public boolean isJoinableJtaTransaction(TransactionCoordinator transactionCoordinator, CMTTransaction transaction) {
        try {
            int status = transactionCoordinator.getTransactionContext().getTransactionEnvironment().getJtaPlatform().getCurrentStatus();
            return JtaStatusHelper.isActive(status);
        }
        catch (SystemException se) {
            throw new TransactionException("Unable to check transaction status", se);
        }
    }
}

