/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.event.internal;

import org.evosuite.shaded.org.hibernate.LockMode;
import org.evosuite.shaded.org.hibernate.LockOptions;
import org.evosuite.shaded.org.hibernate.ObjectDeletedException;
import org.evosuite.shaded.org.hibernate.cache.spi.CacheKey;
import org.evosuite.shaded.org.hibernate.cache.spi.access.SoftLock;
import org.evosuite.shaded.org.hibernate.engine.spi.EntityEntry;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.Status;
import org.evosuite.shaded.org.hibernate.event.internal.AbstractReassociateEventListener;
import org.evosuite.shaded.org.hibernate.event.spi.EventSource;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.persister.entity.EntityPersister;
import org.evosuite.shaded.org.hibernate.pretty.MessageHelper;
import org.evosuite.shaded.org.jboss.logging.Logger;

public abstract class AbstractLockUpgradeEventListener
extends AbstractReassociateEventListener {
    private static final Logger log = CoreLogging.logger(AbstractLockUpgradeEventListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void upgradeLock(Object object, EntityEntry entry, LockOptions lockOptions, EventSource source) {
        SoftLock lock;
        CacheKey ck;
        LockMode requestedLockMode = lockOptions.getLockMode();
        if (!requestedLockMode.greaterThan(entry.getLockMode())) return;
        if (entry.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("attempted to lock a deleted instance", entry.getId(), entry.getPersister().getEntityName());
        }
        EntityPersister persister = entry.getPersister();
        if (log.isTraceEnabled()) {
            log.tracev("Locking {0} in mode: {1}", (Object)MessageHelper.infoString(persister, entry.getId(), source.getFactory()), (Object)requestedLockMode);
        }
        if (persister.hasCache()) {
            ck = source.generateCacheKey(entry.getId(), persister.getIdentifierType(), persister.getRootEntityName());
            lock = persister.getCacheAccessStrategy().lockItem(ck, entry.getVersion());
        } else {
            ck = null;
            lock = null;
        }
        try {
            if (persister.isVersioned() && requestedLockMode == LockMode.FORCE) {
                Object nextVersion = persister.forceVersionIncrement(entry.getId(), entry.getVersion(), source);
                entry.forceLocked(object, nextVersion);
            } else {
                persister.lock(entry.getId(), entry.getVersion(), object, lockOptions, (SessionImplementor)source);
            }
            entry.setLockMode(requestedLockMode);
            if (!persister.hasCache()) return;
        }
        catch (Throwable throwable) {
            if (!persister.hasCache()) throw throwable;
            persister.getCacheAccessStrategy().unlockItem(ck, lock);
            throw throwable;
        }
        persister.getCacheAccessStrategy().unlockItem(ck, lock);
    }
}

