/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.event.internal;

import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.event.internal.AbstractFlushingEventListener;
import org.evosuite.shaded.org.hibernate.event.spi.DirtyCheckEvent;
import org.evosuite.shaded.org.hibernate.event.spi.DirtyCheckEventListener;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class DefaultDirtyCheckEventListener
extends AbstractFlushingEventListener
implements DirtyCheckEventListener {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DefaultDirtyCheckEventListener.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDirtyCheck(DirtyCheckEvent event) throws HibernateException {
        int oldSize = event.getSession().getActionQueue().numberOfCollectionRemovals();
        try {
            this.flushEverythingToExecutions(event);
            boolean wasNeeded = event.getSession().getActionQueue().hasAnyQueuedActions();
            if (wasNeeded) {
                LOG.debug("Session dirty");
            } else {
                LOG.debug("Session not dirty");
            }
            event.setDirty(wasNeeded);
        }
        finally {
            event.getSession().getActionQueue().clearFromFlushNeededCheck(oldSize);
        }
    }
}

