/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.event.internal;

import java.io.Serializable;
import org.evosuite.shaded.org.hibernate.AssertionFailure;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.LockMode;
import org.evosuite.shaded.org.hibernate.PersistentObjectException;
import org.evosuite.shaded.org.hibernate.TransientObjectException;
import org.evosuite.shaded.org.hibernate.classic.Lifecycle;
import org.evosuite.shaded.org.hibernate.engine.internal.Cascade;
import org.evosuite.shaded.org.hibernate.engine.internal.CascadePoint;
import org.evosuite.shaded.org.hibernate.engine.spi.CascadingAction;
import org.evosuite.shaded.org.hibernate.engine.spi.CascadingActions;
import org.evosuite.shaded.org.hibernate.engine.spi.EntityEntry;
import org.evosuite.shaded.org.hibernate.engine.spi.EntityKey;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.Status;
import org.evosuite.shaded.org.hibernate.event.internal.AbstractSaveEventListener;
import org.evosuite.shaded.org.hibernate.event.internal.OnUpdateVisitor;
import org.evosuite.shaded.org.hibernate.event.spi.EventSource;
import org.evosuite.shaded.org.hibernate.event.spi.SaveOrUpdateEvent;
import org.evosuite.shaded.org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.persister.entity.EntityPersister;
import org.evosuite.shaded.org.hibernate.pretty.MessageHelper;
import org.evosuite.shaded.org.hibernate.proxy.HibernateProxy;

public class DefaultSaveOrUpdateEventListener
extends AbstractSaveEventListener
implements SaveOrUpdateEventListener {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DefaultSaveOrUpdateEventListener.class);

    @Override
    public void onSaveOrUpdate(SaveOrUpdateEvent event) {
        EventSource source = event.getSession();
        Object object = event.getObject();
        Serializable requestedId = event.getRequestedId();
        if (requestedId != null && object instanceof HibernateProxy) {
            ((HibernateProxy)object).getHibernateLazyInitializer().setIdentifier(requestedId);
        }
        if (this.reassociateIfUninitializedProxy(object, source)) {
            LOG.trace("Reassociated uninitialized proxy");
        } else {
            Object entity = source.getPersistenceContext().unproxyAndReassociate(object);
            event.setEntity(entity);
            event.setEntry(source.getPersistenceContext().getEntry(entity));
            event.setResultId(this.performSaveOrUpdate(event));
        }
    }

    protected boolean reassociateIfUninitializedProxy(Object object, SessionImplementor source) {
        return source.getPersistenceContext().reassociateIfUninitializedProxy(object);
    }

    protected Serializable performSaveOrUpdate(SaveOrUpdateEvent event) {
        AbstractSaveEventListener.EntityState entityState = this.getEntityState(event.getEntity(), event.getEntityName(), event.getEntry(), event.getSession());
        switch (entityState) {
            case DETACHED: {
                this.entityIsDetached(event);
                return null;
            }
            case PERSISTENT: {
                return this.entityIsPersistent(event);
            }
        }
        return this.entityIsTransient(event);
    }

    protected Serializable entityIsPersistent(SaveOrUpdateEvent event) throws HibernateException {
        Serializable savedId;
        EntityEntry entityEntry;
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled) {
            LOG.trace("Ignoring persistent instance");
        }
        if ((entityEntry = event.getEntry()) == null) {
            throw new AssertionFailure("entity was transient or detached");
        }
        if (entityEntry.getStatus() == Status.DELETED) {
            throw new AssertionFailure("entity was deleted");
        }
        SessionFactoryImplementor factory = event.getSession().getFactory();
        Serializable requestedId = event.getRequestedId();
        if (requestedId == null) {
            savedId = entityEntry.getId();
        } else {
            boolean isEqual;
            boolean bl = isEqual = !entityEntry.getPersister().getIdentifierType().isEqual(requestedId, entityEntry.getId(), factory);
            if (isEqual) {
                throw new PersistentObjectException("object passed to save() was already persistent: " + MessageHelper.infoString(entityEntry.getPersister(), requestedId, factory));
            }
            savedId = requestedId;
        }
        if (traceEnabled) {
            LOG.tracev("Object already associated with session: {0}", (Object)MessageHelper.infoString(entityEntry.getPersister(), savedId, factory));
        }
        return savedId;
    }

    protected Serializable entityIsTransient(SaveOrUpdateEvent event) {
        LOG.trace("Saving transient instance");
        EventSource source = event.getSession();
        EntityEntry entityEntry = event.getEntry();
        if (entityEntry != null) {
            if (entityEntry.getStatus() == Status.DELETED) {
                source.forceFlush(entityEntry);
            } else {
                throw new AssertionFailure("entity was persistent");
            }
        }
        Serializable id = this.saveWithGeneratedOrRequestedId(event);
        source.getPersistenceContext().reassociateProxy(event.getObject(), id);
        return id;
    }

    protected Serializable saveWithGeneratedOrRequestedId(SaveOrUpdateEvent event) {
        return this.saveWithGeneratedId(event.getEntity(), event.getEntityName(), null, event.getSession(), true);
    }

    protected void entityIsDetached(SaveOrUpdateEvent event) {
        LOG.trace("Updating detached instance");
        if (event.getSession().getPersistenceContext().isEntryFor(event.getEntity())) {
            throw new AssertionFailure("entity was persistent");
        }
        Object entity = event.getEntity();
        EntityPersister persister = event.getSession().getEntityPersister(event.getEntityName(), entity);
        event.setRequestedId(this.getUpdateId(entity, persister, event.getRequestedId(), event.getSession()));
        this.performUpdate(event, entity, persister);
    }

    protected Serializable getUpdateId(Object entity, EntityPersister persister, Serializable requestedId, SessionImplementor session) {
        Serializable id = persister.getIdentifier(entity, session);
        if (id == null) {
            throw new TransientObjectException("The given object has a null identifier: " + persister.getEntityName());
        }
        return id;
    }

    protected void performUpdate(SaveOrUpdateEvent event, Object entity, EntityPersister persister) throws HibernateException {
        boolean traceEnabled = LOG.isTraceEnabled();
        if (traceEnabled && !persister.isMutable()) {
            LOG.trace("Immutable instance passed to performUpdate()");
        }
        if (traceEnabled) {
            LOG.tracev("Updating {0}", (Object)MessageHelper.infoString(persister, event.getRequestedId(), event.getSession().getFactory()));
        }
        EventSource source = event.getSession();
        EntityKey key = source.generateEntityKey(event.getRequestedId(), persister);
        source.getPersistenceContext().checkUniqueness(key, entity);
        if (this.invokeUpdateLifecycle(entity, persister, source)) {
            this.reassociate(event, event.getObject(), event.getRequestedId(), persister);
            return;
        }
        new OnUpdateVisitor(source, event.getRequestedId(), entity).process(entity, persister);
        source.getPersistenceContext().addEntity(entity, persister.isMutable() ? Status.MANAGED : Status.READ_ONLY, null, key, persister.getVersion(entity), LockMode.NONE, true, persister, false, true);
        persister.afterReassociate(entity, source);
        if (traceEnabled) {
            LOG.tracev("Updating {0}", (Object)MessageHelper.infoString(persister, event.getRequestedId(), source.getFactory()));
        }
        this.cascadeOnUpdate(event, persister, entity);
    }

    protected boolean invokeUpdateLifecycle(Object entity, EntityPersister persister, EventSource source) {
        if (persister.implementsLifecycle()) {
            LOG.debug("Calling onUpdate()");
            if (((Lifecycle)entity).onUpdate(source)) {
                LOG.debug("Update vetoed by onUpdate()");
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeOnUpdate(SaveOrUpdateEvent event, EntityPersister persister, Object entity) {
        EventSource source = event.getSession();
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(CascadingActions.SAVE_UPDATE, CascadePoint.AFTER_UPDATE, source).cascade(persister, entity);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    @Override
    protected CascadingAction getCascadeAction() {
        return CascadingActions.SAVE_UPDATE;
    }
}

