/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.event.internal;

import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.collection.spi.PersistentCollection;
import org.evosuite.shaded.org.hibernate.event.internal.AbstractVisitor;
import org.evosuite.shaded.org.hibernate.event.spi.EventSource;
import org.evosuite.shaded.org.hibernate.type.CollectionType;

public class DirtyCollectionSearchVisitor
extends AbstractVisitor {
    private boolean dirty;
    private boolean[] propertyVersionability;

    DirtyCollectionSearchVisitor(EventSource session, boolean[] propertyVersionability) {
        super(session);
        this.propertyVersionability = propertyVersionability;
    }

    boolean wasDirtyCollectionFound() {
        return this.dirty;
    }

    @Override
    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        if (collection != null) {
            EventSource session = this.getSession();
            PersistentCollection persistentCollection = type.isArrayType() ? session.getPersistenceContext().getCollectionHolder(collection) : (PersistentCollection)collection;
            if (persistentCollection.isDirty()) {
                this.dirty = true;
                return null;
            }
        }
        return null;
    }

    @Override
    boolean includeEntityProperty(Object[] values, int i) {
        return this.propertyVersionability[i] && super.includeEntityProperty(values, i);
    }
}

