/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.event.internal;

import java.io.Serializable;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.collection.spi.PersistentCollection;
import org.evosuite.shaded.org.hibernate.event.internal.AbstractVisitor;
import org.evosuite.shaded.org.hibernate.event.spi.EventSource;
import org.evosuite.shaded.org.hibernate.persister.collection.CollectionPersister;
import org.evosuite.shaded.org.hibernate.type.CollectionType;
import org.evosuite.shaded.org.hibernate.type.EntityType;

public abstract class ProxyVisitor
extends AbstractVisitor {
    public ProxyVisitor(EventSource session) {
        super(session);
    }

    @Override
    Object processEntity(Object value, EntityType entityType) throws HibernateException {
        if (value != null) {
            this.getSession().getPersistenceContext().reassociateIfUninitializedProxy(value);
        }
        return null;
    }

    protected static boolean isOwnerUnchanged(PersistentCollection snapshot, CollectionPersister persister, Serializable id) {
        return ProxyVisitor.isCollectionSnapshotValid(snapshot) && persister.getRole().equals(snapshot.getRole()) && id.equals(snapshot.getKey());
    }

    private static boolean isCollectionSnapshotValid(PersistentCollection snapshot) {
        return snapshot != null && snapshot.getRole() != null && snapshot.getKey() != null;
    }

    protected void reattachCollection(PersistentCollection collection, CollectionType type) throws HibernateException {
        if (collection.wasInitialized()) {
            CollectionPersister collectionPersister = this.getSession().getFactory().getCollectionPersister(type.getRole());
            this.getSession().getPersistenceContext().addInitializedDetachedCollection(collectionPersister, collection);
        } else {
            if (!ProxyVisitor.isCollectionSnapshotValid(collection)) {
                throw new HibernateException("could not reassociate uninitialized transient collection");
            }
            CollectionPersister collectionPersister = this.getSession().getFactory().getCollectionPersister(collection.getRole());
            this.getSession().getPersistenceContext().addUninitializedDetachedCollection(collectionPersister, collection);
        }
    }
}

