/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.hql.internal.ast;

import java.lang.reflect.Constructor;
import org.evosuite.shaded.antlr.ASTFactory;
import org.evosuite.shaded.antlr.Token;
import org.evosuite.shaded.antlr.collections.AST;
import org.evosuite.shaded.org.hibernate.hql.internal.antlr.HqlSqlTokenTypes;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.AggregateNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.BetweenOperatorNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.BinaryArithmeticOperatorNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.BinaryLogicOperatorNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.BooleanLiteralNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.CastFunctionNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.CollectionFunction;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.ConstructorNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.CountNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.DeleteStatement;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.DotNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.FromClause;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.FromElement;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.IdentNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.ImpliedFromElement;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.InLogicOperatorNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.IndexNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.InitializeableNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.InsertStatement;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.IntoClause;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.IsNotNullLogicOperatorNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.IsNullLogicOperatorNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.JavaConstantNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.LiteralNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.MapEntryNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.MapKeyNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.MapValueNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.MethodNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.OrderByClause;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.ParameterNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.QueryNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.ResultVariableRefNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.SearchedCaseNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.SelectClause;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.SelectExpressionImpl;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.SessionFactoryAwareNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.SimpleCaseNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.SqlFragment;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.SqlNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.UnaryArithmeticNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.UnaryLogicOperatorNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.UpdateStatement;

public class SqlASTFactory
extends ASTFactory
implements HqlSqlTokenTypes {
    private HqlSqlWalker walker;

    public SqlASTFactory(HqlSqlWalker walker) {
        this.walker = walker;
    }

    @Override
    public Class getASTNodeType(int tokenType) {
        switch (tokenType) {
            case 45: 
            case 90: {
                return QueryNode.class;
            }
            case 51: {
                return UpdateStatement.class;
            }
            case 13: {
                return DeleteStatement.class;
            }
            case 29: {
                return InsertStatement.class;
            }
            case 30: {
                return IntoClause.class;
            }
            case 22: {
                return FromClause.class;
            }
            case 138: {
                return FromElement.class;
            }
            case 139: {
                return ImpliedFromElement.class;
            }
            case 15: {
                return DotNode.class;
            }
            case 82: {
                return IndexNode.class;
            }
            case 109: 
            case 144: {
                return IdentNode.class;
            }
            case 154: {
                return ResultVariableRefNode.class;
            }
            case 146: {
                return SqlFragment.class;
            }
            case 85: {
                return MethodNode.class;
            }
            case 78: {
                return CastFunctionNode.class;
            }
            case 17: 
            case 27: {
                return CollectionFunction.class;
            }
            case 141: {
                return SelectClause.class;
            }
            case 148: {
                return SelectExpressionImpl.class;
            }
            case 74: {
                return AggregateNode.class;
            }
            case 12: {
                return CountNode.class;
            }
            case 76: {
                return ConstructorNode.class;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 127: 
            case 130: {
                return LiteralNode.class;
            }
            case 20: 
            case 49: {
                return BooleanLiteralNode.class;
            }
            case 104: {
                return JavaConstantNode.class;
            }
            case 41: {
                return OrderByClause.class;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: {
                return BinaryArithmeticOperatorNode.class;
            }
            case 94: 
            case 95: {
                return UnaryArithmeticNode.class;
            }
            case 77: {
                return SimpleCaseNode.class;
            }
            case 57: {
                return SearchedCaseNode.class;
            }
            case 129: 
            case 152: {
                return ParameterNode.class;
            }
            case 34: 
            case 88: 
            case 106: 
            case 113: 
            case 115: 
            case 116: 
            case 117: 
            case 118: {
                return BinaryLogicOperatorNode.class;
            }
            case 26: 
            case 87: {
                return InLogicOperatorNode.class;
            }
            case 10: 
            case 86: {
                return BetweenOperatorNode.class;
            }
            case 84: {
                return IsNullLogicOperatorNode.class;
            }
            case 83: {
                return IsNotNullLogicOperatorNode.class;
            }
            case 19: {
                return UnaryLogicOperatorNode.class;
            }
            case 71: {
                return MapKeyNode.class;
            }
            case 72: {
                return MapValueNode.class;
            }
            case 73: {
                return MapEntryNode.class;
            }
        }
        return SqlNode.class;
    }

    @Override
    protected AST createUsingCtor(Token token, String className) {
        AST t;
        try {
            Class<?> c = Class.forName(className);
            Class[] tokenArgType = new Class[]{Token.class};
            Constructor<?> ctor = c.getConstructor(tokenArgType);
            if (ctor != null) {
                t = (AST)ctor.newInstance(token);
                this.initializeSqlNode(t);
            } else {
                t = this.create(c);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid class or can't make instance, " + className);
        }
        return t;
    }

    private void initializeSqlNode(AST t) {
        if (t instanceof InitializeableNode) {
            InitializeableNode initializeableNode = (InitializeableNode)((Object)t);
            initializeableNode.initialize(this.walker);
        }
        if (t instanceof SessionFactoryAwareNode) {
            ((SessionFactoryAwareNode)((Object)t)).setSessionFactory(this.walker.getSessionFactoryHelper().getFactory());
        }
    }

    @Override
    protected AST create(Class c) {
        AST t;
        try {
            t = (AST)c.newInstance();
            this.initializeSqlNode(t);
        }
        catch (Exception e) {
            this.error("Can't create AST Node " + c.getName());
            return null;
        }
        return t;
    }
}

