/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.hql.internal.ast.exec;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.evosuite.shaded.antlr.RecognitionException;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.action.internal.BulkOperationCleanupAction;
import org.evosuite.shaded.org.hibernate.engine.spi.QueryParameters;
import org.evosuite.shaded.org.hibernate.engine.spi.RowSelection;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.event.spi.EventSource;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.QuerySyntaxException;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.SqlGenerator;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.exec.StatementExecutor;
import org.evosuite.shaded.org.hibernate.param.ParameterSpecification;
import org.evosuite.shaded.org.hibernate.persister.entity.Queryable;

public class BasicExecutor
implements StatementExecutor {
    private final SessionFactoryImplementor factory;
    private final Queryable persister;
    private final String sql;
    private final List parameterSpecifications;

    public BasicExecutor(HqlSqlWalker walker, Queryable persister) {
        this.factory = walker.getSessionFactoryHelper().getFactory();
        this.persister = persister;
        try {
            SqlGenerator gen = new SqlGenerator(this.factory);
            gen.statement(walker.getAST());
            this.sql = gen.getSQL();
            gen.getParseErrorHandler().throwQueryException();
            this.parameterSpecifications = gen.getCollectedParameters();
        }
        catch (RecognitionException e) {
            throw QuerySyntaxException.convert(e);
        }
    }

    @Override
    public String[] getSqlStatements() {
        return new String[]{this.sql};
    }

    @Override
    public int execute(QueryParameters parameters, SessionImplementor session) throws HibernateException {
        return this.doExecute(parameters, session, this.sql, this.parameterSpecifications);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doExecute(QueryParameters parameters, SessionImplementor session, String sql, List parameterSpecifications) throws HibernateException {
        BulkOperationCleanupAction action = new BulkOperationCleanupAction(session, this.persister);
        if (session.isEventSource()) {
            ((EventSource)session).getActionQueue().addAction(action);
        } else {
            action.getAfterTransactionCompletionProcess().doAfterTransactionCompletion(true, session);
        }
        PreparedStatement st = null;
        RowSelection selection = parameters.getRowSelection();
        try {
            st = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(sql, false);
            Iterator paramSpecItr = parameterSpecifications.iterator();
            int pos = 1;
            while (paramSpecItr.hasNext()) {
                ParameterSpecification paramSpec = (ParameterSpecification)paramSpecItr.next();
                pos += paramSpec.bind(st, parameters, session, pos);
            }
            if (selection != null && selection.getTimeout() != null) {
                st.setQueryTimeout(selection.getTimeout());
            }
            int n = session.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(st);
            if (st != null) {
                session.getTransactionCoordinator().getJdbcCoordinator().release(st);
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (st != null) {
                    session.getTransactionCoordinator().getJdbcCoordinator().release(st);
                }
                throw throwable;
            }
            catch (SQLException sqle) {
                throw this.factory.getSQLExceptionHelper().convert(sqle, "could not execute update query", sql);
            }
        }
    }
}

