/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.hql.internal.ast.exec;

import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.action.internal.BulkOperationCleanupAction;
import org.evosuite.shaded.org.hibernate.engine.spi.QueryParameters;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.event.spi.EventSource;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.exec.StatementExecutor;
import org.evosuite.shaded.org.hibernate.hql.spi.MultiTableBulkIdStrategy;

public class MultiTableDeleteExecutor
implements StatementExecutor {
    private final MultiTableBulkIdStrategy.DeleteHandler deleteHandler;

    public MultiTableDeleteExecutor(HqlSqlWalker walker) {
        MultiTableBulkIdStrategy strategy = walker.getSessionFactoryHelper().getFactory().getSettings().getMultiTableBulkIdStrategy();
        this.deleteHandler = strategy.buildDeleteHandler(walker.getSessionFactoryHelper().getFactory(), walker);
    }

    @Override
    public String[] getSqlStatements() {
        return this.deleteHandler.getSqlStatements();
    }

    @Override
    public int execute(QueryParameters parameters, SessionImplementor session) throws HibernateException {
        BulkOperationCleanupAction action = new BulkOperationCleanupAction(session, this.deleteHandler.getTargetedQueryable());
        if (session.isEventSource()) {
            ((EventSource)session).getActionQueue().addAction(action);
        } else {
            action.getAfterTransactionCompletionProcess().doAfterTransactionCompletion(true, session);
        }
        return this.deleteHandler.execute(session, parameters);
    }
}

