/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.hql.internal.ast.tree;

import org.evosuite.shaded.org.hibernate.QueryException;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.ExpectedTypeAwareNode;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.LiteralNode;
import org.evosuite.shaded.org.hibernate.type.LiteralType;
import org.evosuite.shaded.org.hibernate.type.StandardBasicTypes;
import org.evosuite.shaded.org.hibernate.type.Type;

public class BooleanLiteralNode
extends LiteralNode
implements ExpectedTypeAwareNode {
    private Type expectedType;

    @Override
    public Type getDataType() {
        return this.expectedType == null ? StandardBasicTypes.BOOLEAN : this.expectedType;
    }

    public Boolean getValue() {
        return this.getType() == 49;
    }

    @Override
    public void setExpectedType(Type expectedType) {
        this.expectedType = expectedType;
    }

    @Override
    public Type getExpectedType() {
        return this.expectedType;
    }

    @Override
    public String getRenderText(SessionFactoryImplementor sessionFactory) {
        try {
            return this.typeAsLiteralType().objectToSQLString(this.getValue(), sessionFactory.getDialect());
        }
        catch (Exception t) {
            throw new QueryException("Unable to render boolean literal value", t);
        }
    }

    private LiteralType typeAsLiteralType() {
        return (LiteralType)((Object)this.getDataType());
    }
}

