/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.hql.internal.ast.tree;

import org.evosuite.shaded.antlr.CommonAST;
import org.evosuite.shaded.antlr.Token;
import org.evosuite.shaded.antlr.collections.AST;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;

public class Node
extends CommonAST {
    private String filename;
    private int line;
    private int column;
    private int textLength;

    public Node() {
    }

    public Node(Token tok) {
        super(tok);
    }

    public String getRenderText(SessionFactoryImplementor sessionFactory) {
        return this.getText();
    }

    @Override
    public void initialize(Token tok) {
        super.initialize(tok);
        this.filename = tok.getFilename();
        this.line = tok.getLine();
        this.column = tok.getColumn();
        String text = tok.getText();
        this.textLength = StringHelper.isEmpty(text) ? 0 : text.length();
    }

    @Override
    public void initialize(AST t) {
        super.initialize(t);
        if (t instanceof Node) {
            Node n = (Node)t;
            this.filename = n.filename;
            this.line = n.line;
            this.column = n.column;
            this.textLength = n.textLength;
        }
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    public int getTextLength() {
        return this.textLength;
    }
}

