/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.hql.spi;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.shaded.org.hibernate.engine.spi.QueryParameters;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.DeleteStatement;
import org.evosuite.shaded.org.hibernate.hql.internal.ast.tree.FromElement;
import org.evosuite.shaded.org.hibernate.hql.spi.AbstractTableBasedBulkIdHandler;
import org.evosuite.shaded.org.hibernate.hql.spi.MultiTableBulkIdStrategy;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;
import org.evosuite.shaded.org.hibernate.param.ParameterSpecification;
import org.evosuite.shaded.org.hibernate.persister.collection.AbstractCollectionPersister;
import org.evosuite.shaded.org.hibernate.persister.entity.Queryable;
import org.evosuite.shaded.org.hibernate.sql.Delete;
import org.evosuite.shaded.org.hibernate.type.CollectionType;
import org.evosuite.shaded.org.hibernate.type.Type;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class TableBasedDeleteHandlerImpl
extends AbstractTableBasedBulkIdHandler
implements MultiTableBulkIdStrategy.DeleteHandler {
    private static final Logger log = Logger.getLogger(TableBasedDeleteHandlerImpl.class);
    private final Queryable targetedPersister;
    private final String idInsertSelect;
    private final List<ParameterSpecification> idSelectParameterSpecifications;
    private final List<String> deletes;

    public TableBasedDeleteHandlerImpl(SessionFactoryImplementor factory, HqlSqlWalker walker) {
        this(factory, walker, null, null);
    }

    public TableBasedDeleteHandlerImpl(SessionFactoryImplementor factory, HqlSqlWalker walker, String catalog, String schema) {
        super(factory, walker, catalog, schema);
        DeleteStatement deleteStatement = (DeleteStatement)walker.getAST();
        FromElement fromElement = deleteStatement.getFromClause().getFromElement();
        this.targetedPersister = fromElement.getQueryable();
        String bulkTargetAlias = fromElement.getTableAlias();
        AbstractTableBasedBulkIdHandler.ProcessedWhereClause processedWhereClause = this.processWhereClause(deleteStatement.getWhereClause());
        this.idSelectParameterSpecifications = processedWhereClause.getIdSelectParameterSpecifications();
        this.idInsertSelect = this.generateIdInsertSelect(this.targetedPersister, bulkTargetAlias, processedWhereClause);
        log.tracev("Generated ID-INSERT-SELECT SQL (multi-table delete) : {0}", (Object)this.idInsertSelect);
        String idSubselect = this.generateIdSubselect(this.targetedPersister);
        this.deletes = new ArrayList<String>();
        for (Type type : this.targetedPersister.getPropertyTypes()) {
            CollectionType cType;
            AbstractCollectionPersister cPersister;
            if (!type.isCollectionType() || !(cPersister = (AbstractCollectionPersister)factory.getCollectionPersister((cType = (CollectionType)type).getRole())).isManyToMany()) continue;
            this.deletes.add(this.generateDelete(cPersister.getTableName(), cPersister.getKeyColumnNames(), idSubselect, "bulk delete - m2m join table cleanup"));
        }
        String[] tableNames = this.targetedPersister.getConstraintOrderedTableNameClosure();
        String[][] columnNames = this.targetedPersister.getContraintOrderedTableKeyColumnClosure();
        for (int i = 0; i < tableNames.length; ++i) {
            this.deletes.add(this.generateDelete(tableNames[i], columnNames[i], idSubselect, "bulk delete"));
        }
    }

    private String generateDelete(String tableName, String[] columnNames, String idSubselect, String comment) {
        Delete delete = new Delete().setTableName(tableName).setWhere("(" + StringHelper.join(", ", columnNames) + ") IN (" + idSubselect + ")");
        if (this.factory().getSettings().isCommentsEnabled()) {
            delete.setComment(comment);
        }
        return delete.toStatementString();
    }

    @Override
    public Queryable getTargetedQueryable() {
        return this.targetedPersister;
    }

    @Override
    public String[] getSqlStatements() {
        return this.deletes.toArray(new String[this.deletes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(SessionImplementor session, QueryParameters queryParameters) {
        this.prepareForUse(this.targetedPersister, session);
        try {
            PreparedStatement ps = null;
            int resultCount = 0;
            try {
                try {
                    ps = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(this.idInsertSelect, false);
                    int pos = 1;
                    pos += this.handlePrependedParametersOnIdSelection(ps, session, pos);
                    for (ParameterSpecification parameterSpecification : this.idSelectParameterSpecifications) {
                        pos += parameterSpecification.bind(ps, queryParameters, session, pos);
                    }
                    resultCount = session.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(ps);
                }
                finally {
                    if (ps != null) {
                        session.getTransactionCoordinator().getJdbcCoordinator().release(ps);
                    }
                }
            }
            catch (SQLException e) {
                throw this.convert(e, "could not insert/select ids for bulk delete", this.idInsertSelect);
            }
            for (String delete : this.deletes) {
                try {
                    try {
                        ps = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(delete, false);
                        this.handleAddedParametersOnDelete(ps, session);
                        session.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(ps);
                    }
                    finally {
                        if (ps == null) continue;
                        session.getTransactionCoordinator().getJdbcCoordinator().release(ps);
                    }
                }
                catch (SQLException e) {
                    throw this.convert(e, "error performing bulk delete", delete);
                }
            }
            int n = resultCount;
            return n;
        }
        finally {
            this.releaseFromUse(this.targetedPersister, session);
        }
    }

    protected int handlePrependedParametersOnIdSelection(PreparedStatement ps, SessionImplementor session, int pos) throws SQLException {
        return 0;
    }

    protected void handleAddedParametersOnDelete(PreparedStatement ps, SessionImplementor session) throws SQLException {
    }
}

