/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.id;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.id.IdentifierGenerator;
import org.evosuite.shaded.org.hibernate.id.IdentifierGeneratorAggregator;

public class CompositeNestedGeneratedValueGenerator
implements IdentifierGenerator,
Serializable,
IdentifierGeneratorAggregator {
    private final GenerationContextLocator generationContextLocator;
    private List generationPlans = new ArrayList();

    public CompositeNestedGeneratedValueGenerator(GenerationContextLocator generationContextLocator) {
        this.generationContextLocator = generationContextLocator;
    }

    public void addGeneratedValuePlan(GenerationPlan plan) {
        this.generationPlans.add(plan);
    }

    @Override
    public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        Serializable context = this.generationContextLocator.locateGenerationContext(session, object);
        for (Object generationPlan : this.generationPlans) {
            GenerationPlan plan = (GenerationPlan)generationPlan;
            plan.execute(session, object, context);
        }
        return context;
    }

    @Override
    public void registerPersistentGenerators(Map generatorMap) {
        for (Object generationPlan : this.generationPlans) {
            GenerationPlan plan = (GenerationPlan)generationPlan;
            plan.registerPersistentGenerators(generatorMap);
        }
    }

    public static interface GenerationPlan {
        public void execute(SessionImplementor var1, Object var2, Object var3);

        public void registerPersistentGenerators(Map var1);
    }

    public static interface GenerationContextLocator {
        public Serializable locateGenerationContext(SessionImplementor var1, Object var2);
    }
}

