/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.MappingException;
import org.evosuite.shaded.org.hibernate.cfg.ObjectNameNormalizer;
import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.id.Configurable;
import org.evosuite.shaded.org.hibernate.id.IdentifierGenerator;
import org.evosuite.shaded.org.hibernate.id.IdentifierGeneratorHelper;
import org.evosuite.shaded.org.hibernate.id.IntegralDataTypeHolder;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.internal.util.StringHelper;
import org.evosuite.shaded.org.hibernate.mapping.Table;
import org.evosuite.shaded.org.hibernate.type.Type;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class IncrementGenerator
implements IdentifierGenerator,
Configurable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, IncrementGenerator.class.getName());
    private Class returnClass;
    private String sql;
    private IntegralDataTypeHolder previousValueHolder;

    @Override
    public synchronized Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        if (this.sql != null) {
            this.initializePreviousValueHolder(session);
        }
        return this.previousValueHolder.makeValueThenIncrement();
    }

    @Override
    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        this.returnClass = type.getReturnedClass();
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        String column = params.getProperty("column");
        if (column == null) {
            column = params.getProperty("target_column");
        }
        column = dialect.quote(normalizer.normalizeIdentifierQuoting(column));
        String tableList = params.getProperty("tables");
        if (tableList == null) {
            tableList = params.getProperty("identity_tables");
        }
        String[] tables = StringHelper.split(", ", tableList);
        String schema = dialect.quote(normalizer.normalizeIdentifierQuoting(params.getProperty("schema")));
        String catalog = dialect.quote(normalizer.normalizeIdentifierQuoting(params.getProperty("catalog")));
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < tables.length; ++i) {
            String tableName = dialect.quote(normalizer.normalizeIdentifierQuoting(tables[i]));
            if (tables.length > 1) {
                buf.append("select max(").append(column).append(") as mx from ");
            }
            buf.append(Table.qualify(catalog, schema, tableName));
            if (i >= tables.length - 1) continue;
            buf.append(" union ");
        }
        if (tables.length > 1) {
            buf.insert(0, "( ").append(" ) ids_");
            column = "ids_.mx";
        }
        this.sql = "select max(" + column + ") from " + buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePreviousValueHolder(SessionImplementor session) {
        this.previousValueHolder = IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.returnClass);
        boolean debugEnabled = LOG.isDebugEnabled();
        if (debugEnabled) {
            LOG.debugf("Fetching initial value: %s", (Object)this.sql);
        }
        try {
            PreparedStatement st = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(this.sql);
            try {
                ResultSet rs = session.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().extract(st);
                try {
                    if (rs.next()) {
                        this.previousValueHolder.initialize(rs, 0L).increment();
                    } else {
                        this.previousValueHolder.initialize(1L);
                    }
                    this.sql = null;
                    if (debugEnabled) {
                        LOG.debugf("First free id: %s", (Object)this.previousValueHolder.makeValue());
                    }
                }
                finally {
                    session.getTransactionCoordinator().getJdbcCoordinator().release(rs, st);
                }
            }
            finally {
                session.getTransactionCoordinator().getJdbcCoordinator().release(st);
            }
        }
        catch (SQLException sqle) {
            throw session.getFactory().getSQLExceptionHelper().convert(sqle, "could not fetch initial value for increment generator", this.sql);
        }
    }
}

