/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.id;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.MappingException;
import org.evosuite.shaded.org.hibernate.cfg.ObjectNameNormalizer;
import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.id.BulkInsertionCapableIdentifierGenerator;
import org.evosuite.shaded.org.hibernate.id.Configurable;
import org.evosuite.shaded.org.hibernate.id.IdentifierGeneratorHelper;
import org.evosuite.shaded.org.hibernate.id.IntegralDataTypeHolder;
import org.evosuite.shaded.org.hibernate.id.PersistentIdentifierGenerator;
import org.evosuite.shaded.org.hibernate.internal.util.config.ConfigurationHelper;
import org.evosuite.shaded.org.hibernate.mapping.Table;
import org.evosuite.shaded.org.hibernate.type.Type;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class SequenceGenerator
implements PersistentIdentifierGenerator,
BulkInsertionCapableIdentifierGenerator,
Configurable {
    private static final Logger LOG = Logger.getLogger(SequenceGenerator.class.getName());
    public static final String SEQUENCE = "sequence";
    public static final String PARAMETERS = "parameters";
    private String sequenceName;
    private String parameters;
    private Type identifierType;
    private String sql;

    protected Type getIdentifierType() {
        return this.identifierType;
    }

    @Override
    public Object generatorKey() {
        return this.getSequenceName();
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    @Override
    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        this.sequenceName = normalizer.normalizeIdentifierQuoting(ConfigurationHelper.getString(SEQUENCE, params, "hibernate_sequence"));
        this.parameters = params.getProperty(PARAMETERS);
        if (this.sequenceName.indexOf(46) < 0) {
            String schemaName = normalizer.normalizeIdentifierQuoting(params.getProperty("schema"));
            String catalogName = normalizer.normalizeIdentifierQuoting(params.getProperty("catalog"));
            this.sequenceName = Table.qualify(dialect.quote(catalogName), dialect.quote(schemaName), dialect.quote(this.sequenceName));
        }
        this.identifierType = type;
        this.sql = dialect.getSequenceNextValString(this.sequenceName);
    }

    @Override
    public Serializable generate(SessionImplementor session, Object obj) {
        return this.generateHolder(session).makeValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected IntegralDataTypeHolder generateHolder(SessionImplementor session) {
        try {
            PreparedStatement st = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(this.sql);
            try {
                ResultSet rs = session.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().extract(st);
                try {
                    rs.next();
                    IntegralDataTypeHolder result = this.buildHolder();
                    result.initialize(rs, 1L);
                    LOG.debugf("Sequence identifier generated: %s", (Object)result);
                    IntegralDataTypeHolder integralDataTypeHolder = result;
                    session.getTransactionCoordinator().getJdbcCoordinator().release(rs, st);
                    return integralDataTypeHolder;
                }
                catch (Throwable throwable) {
                    session.getTransactionCoordinator().getJdbcCoordinator().release(rs, st);
                    throw throwable;
                }
            }
            finally {
                session.getTransactionCoordinator().getJdbcCoordinator().release(st);
            }
        }
        catch (SQLException sqle) {
            throw session.getFactory().getSQLExceptionHelper().convert(sqle, "could not get next sequence value", this.sql);
        }
    }

    protected IntegralDataTypeHolder buildHolder() {
        return IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.identifierType.getReturnedClass());
    }

    @Override
    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        String[] ddl = dialect.getCreateSequenceStrings(this.sequenceName);
        if (this.parameters != null) {
            int n = ddl.length - 1;
            ddl[n] = ddl[n] + ' ' + this.parameters;
        }
        return ddl;
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return dialect.getDropSequenceStrings(this.sequenceName);
    }

    @Override
    public boolean supportsBulkInsertionIdentifierGeneration() {
        return true;
    }

    @Override
    public String determineBulkInsertionIdentifierGenerationSelectFragment(Dialect dialect) {
        return dialect.getSelectSequenceNextValString(this.getSequenceName());
    }
}

