/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.id.enhanced;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.LockMode;
import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.engine.jdbc.internal.FormatStyle;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.JdbcServices;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionEventListenerManager;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.id.IdentifierGenerationException;
import org.evosuite.shaded.org.hibernate.id.IdentifierGeneratorHelper;
import org.evosuite.shaded.org.hibernate.id.IntegralDataTypeHolder;
import org.evosuite.shaded.org.hibernate.id.enhanced.AccessCallback;
import org.evosuite.shaded.org.hibernate.id.enhanced.DatabaseStructure;
import org.evosuite.shaded.org.hibernate.id.enhanced.Optimizer;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.jdbc.AbstractReturningWork;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class TableStructure
implements DatabaseStructure {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, TableStructure.class.getName());
    private final String tableName;
    private final String valueColumnName;
    private final int initialValue;
    private final int incrementSize;
    private final Class numberType;
    private final String selectQuery;
    private final String updateQuery;
    private boolean applyIncrementSizeToSourceValues;
    private int accessCounter;

    public TableStructure(Dialect dialect, String tableName, String valueColumnName, int initialValue, int incrementSize, Class numberType) {
        this.tableName = tableName;
        this.initialValue = initialValue;
        this.incrementSize = incrementSize;
        this.valueColumnName = valueColumnName;
        this.numberType = numberType;
        this.selectQuery = "select " + valueColumnName + " as id_val" + " from " + dialect.appendLockHint(LockMode.PESSIMISTIC_WRITE, tableName) + dialect.getForUpdateString();
        this.updateQuery = "update " + tableName + " set " + valueColumnName + "= ?" + " where " + valueColumnName + "=?";
    }

    @Override
    public String getName() {
        return this.tableName;
    }

    @Override
    public int getInitialValue() {
        return this.initialValue;
    }

    @Override
    public int getIncrementSize() {
        return this.incrementSize;
    }

    @Override
    public int getTimesAccessed() {
        return this.accessCounter;
    }

    @Override
    public void prepare(Optimizer optimizer) {
        this.applyIncrementSizeToSourceValues = optimizer.applyIncrementSizeToSourceValues();
    }

    private IntegralDataTypeHolder makeValue() {
        return IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.numberType);
    }

    @Override
    public AccessCallback buildCallback(final SessionImplementor session) {
        final SqlStatementLogger statementLogger = session.getFactory().getServiceRegistry().getService(JdbcServices.class).getSqlStatementLogger();
        final SessionEventListenerManager statsCollector = session.getEventListenerManager();
        return new AccessCallback(){

            @Override
            public IntegralDataTypeHolder getNextValue() {
                return session.getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork(new AbstractReturningWork<IntegralDataTypeHolder>(){

                    @Override
                    public IntegralDataTypeHolder execute(Connection connection) throws SQLException {
                        int rows;
                        IntegralDataTypeHolder value = TableStructure.this.makeValue();
                        do {
                            PreparedStatement selectStatement = TableStructure.this.prepareStatement(connection, TableStructure.this.selectQuery, statementLogger, statsCollector);
                            try {
                                ResultSet selectRS = TableStructure.this.executeQuery(selectStatement, statsCollector);
                                if (!selectRS.next()) {
                                    String err = "could not read a hi value - you need to populate the table: " + TableStructure.this.tableName;
                                    LOG.error(err);
                                    throw new IdentifierGenerationException(err);
                                }
                                value.initialize(selectRS, 1L);
                                selectRS.close();
                            }
                            catch (SQLException sqle) {
                                LOG.error("could not read a hi value", sqle);
                                throw sqle;
                            }
                            finally {
                                selectStatement.close();
                            }
                            PreparedStatement updatePS = TableStructure.this.prepareStatement(connection, TableStructure.this.updateQuery, statementLogger, statsCollector);
                            try {
                                int increment = TableStructure.this.applyIncrementSizeToSourceValues ? TableStructure.this.incrementSize : 1;
                                IntegralDataTypeHolder updateValue = value.copy().add(increment);
                                updateValue.bind(updatePS, 1);
                                value.bind(updatePS, 2);
                                rows = TableStructure.this.executeUpdate(updatePS, statsCollector);
                            }
                            catch (SQLException e) {
                                LOG.unableToUpdateQueryHiValue(TableStructure.this.tableName, e);
                                throw e;
                            }
                            finally {
                                updatePS.close();
                            }
                        } while (rows == 0);
                        TableStructure.this.accessCounter++;
                        return value;
                    }
                }, true);
            }

            @Override
            public String getTenantIdentifier() {
                return session.getTenantIdentifier();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepareStatement(Connection connection, String sql, SqlStatementLogger statementLogger, SessionEventListenerManager statsCollector) throws SQLException {
        statementLogger.logStatement(sql, FormatStyle.BASIC.getFormatter());
        try {
            statsCollector.jdbcPrepareStatementStart();
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            return preparedStatement;
        }
        finally {
            statsCollector.jdbcPrepareStatementEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdate(PreparedStatement ps, SessionEventListenerManager statsCollector) throws SQLException {
        try {
            statsCollector.jdbcExecuteStatementStart();
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            statsCollector.jdbcExecuteStatementEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeQuery(PreparedStatement ps, SessionEventListenerManager statsCollector) throws SQLException {
        try {
            statsCollector.jdbcExecuteStatementStart();
            ResultSet resultSet = ps.executeQuery();
            return resultSet;
        }
        finally {
            statsCollector.jdbcExecuteStatementEnd();
        }
    }

    @Override
    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getCreateTableString() + " " + this.tableName + " ( " + this.valueColumnName + " " + dialect.getTypeName(-5) + " )", "insert into " + this.tableName + " values ( " + this.initialValue + " )"};
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getDropTableString(this.tableName)};
    }

    @Override
    public boolean isPhysicalSequence() {
        return false;
    }
}

