/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.id.factory.internal;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.shaded.org.hibernate.MappingException;
import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.JdbcServices;
import org.evosuite.shaded.org.hibernate.id.Assigned;
import org.evosuite.shaded.org.hibernate.id.Configurable;
import org.evosuite.shaded.org.hibernate.id.ForeignGenerator;
import org.evosuite.shaded.org.hibernate.id.GUIDGenerator;
import org.evosuite.shaded.org.hibernate.id.IdentifierGenerator;
import org.evosuite.shaded.org.hibernate.id.IdentityGenerator;
import org.evosuite.shaded.org.hibernate.id.IncrementGenerator;
import org.evosuite.shaded.org.hibernate.id.SelectGenerator;
import org.evosuite.shaded.org.hibernate.id.SequenceGenerator;
import org.evosuite.shaded.org.hibernate.id.SequenceHiLoGenerator;
import org.evosuite.shaded.org.hibernate.id.SequenceIdentityGenerator;
import org.evosuite.shaded.org.hibernate.id.TableHiLoGenerator;
import org.evosuite.shaded.org.hibernate.id.UUIDGenerator;
import org.evosuite.shaded.org.hibernate.id.UUIDHexGenerator;
import org.evosuite.shaded.org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.evosuite.shaded.org.hibernate.id.enhanced.TableGenerator;
import org.evosuite.shaded.org.hibernate.id.factory.spi.MutableIdentifierGeneratorFactory;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.internal.util.ReflectHelper;
import org.evosuite.shaded.org.hibernate.service.spi.ServiceRegistryAwareService;
import org.evosuite.shaded.org.hibernate.service.spi.ServiceRegistryImplementor;
import org.evosuite.shaded.org.hibernate.type.Type;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class DefaultIdentifierGeneratorFactory
implements MutableIdentifierGeneratorFactory,
Serializable,
ServiceRegistryAwareService {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DefaultIdentifierGeneratorFactory.class.getName());
    private transient Dialect dialect;
    private ConcurrentHashMap<String, Class> generatorStrategyToClassNameMap = new ConcurrentHashMap();

    public DefaultIdentifierGeneratorFactory() {
        this.register("uuid2", UUIDGenerator.class);
        this.register("guid", GUIDGenerator.class);
        this.register("uuid", UUIDHexGenerator.class);
        this.register("uuid.hex", UUIDHexGenerator.class);
        this.register("hilo", TableHiLoGenerator.class);
        this.register("assigned", Assigned.class);
        this.register("identity", IdentityGenerator.class);
        this.register("select", SelectGenerator.class);
        this.register("sequence", SequenceGenerator.class);
        this.register("seqhilo", SequenceHiLoGenerator.class);
        this.register("increment", IncrementGenerator.class);
        this.register("foreign", ForeignGenerator.class);
        this.register("sequence-identity", SequenceIdentityGenerator.class);
        this.register("enhanced-sequence", SequenceStyleGenerator.class);
        this.register("enhanced-table", TableGenerator.class);
    }

    @Override
    public void register(String strategy, Class generatorClass) {
        LOG.debugf("Registering IdentifierGenerator strategy [%s] -> [%s]", (Object)strategy, (Object)generatorClass.getName());
        Class previous = this.generatorStrategyToClassNameMap.put(strategy, generatorClass);
        if (previous != null) {
            LOG.debugf("    - overriding [%s]", (Object)previous.getName());
        }
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public void setDialect(Dialect dialect) {
        LOG.debugf("Setting dialect [%s]", (Object)dialect);
        this.dialect = dialect;
    }

    @Override
    public IdentifierGenerator createIdentifierGenerator(String strategy, Type type, Properties config) {
        try {
            Class clazz = this.getIdentifierGeneratorClass(strategy);
            IdentifierGenerator identifierGenerator = (IdentifierGenerator)clazz.newInstance();
            if (identifierGenerator instanceof Configurable) {
                ((Configurable)((Object)identifierGenerator)).configure(type, config, this.dialect);
            }
            return identifierGenerator;
        }
        catch (Exception e) {
            String entityName = config.getProperty("entity_name");
            throw new MappingException(String.format("Could not instantiate id generator [entity-name=%s]", entityName), e);
        }
    }

    @Override
    public Class getIdentifierGeneratorClass(String strategy) {
        if ("native".equals(strategy)) {
            return this.dialect.getNativeIdentifierGeneratorClass();
        }
        Class generatorClass = this.generatorStrategyToClassNameMap.get(strategy);
        try {
            if (generatorClass == null) {
                generatorClass = ReflectHelper.classForName(strategy);
            }
        }
        catch (ClassNotFoundException e) {
            throw new MappingException(String.format("Could not interpret id generator strategy [%s]", strategy));
        }
        return generatorClass;
    }

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.dialect = serviceRegistry.getService(JdbcServices.class).getDialect();
    }
}

