/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.internal;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.MappingException;
import org.evosuite.shaded.org.hibernate.MultiTenancyStrategy;
import org.evosuite.shaded.org.hibernate.Query;
import org.evosuite.shaded.org.hibernate.SQLQuery;
import org.evosuite.shaded.org.hibernate.ScrollableResults;
import org.evosuite.shaded.org.hibernate.SessionEventListener;
import org.evosuite.shaded.org.hibernate.SessionException;
import org.evosuite.shaded.org.hibernate.SharedSessionContract;
import org.evosuite.shaded.org.hibernate.cache.spi.CacheKey;
import org.evosuite.shaded.org.hibernate.engine.jdbc.LobCreationContext;
import org.evosuite.shaded.org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.evosuite.shaded.org.hibernate.engine.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.evosuite.shaded.org.hibernate.engine.query.spi.HQLQueryPlan;
import org.evosuite.shaded.org.hibernate.engine.query.spi.NativeSQLQueryPlan;
import org.evosuite.shaded.org.hibernate.engine.query.spi.ParameterMetadata;
import org.evosuite.shaded.org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.evosuite.shaded.org.hibernate.engine.spi.EntityKey;
import org.evosuite.shaded.org.hibernate.engine.spi.NamedQueryDefinition;
import org.evosuite.shaded.org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.evosuite.shaded.org.hibernate.engine.spi.QueryParameters;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionContext;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionEnvironment;
import org.evosuite.shaded.org.hibernate.id.uuid.StandardRandomStrategy;
import org.evosuite.shaded.org.hibernate.internal.QueryImpl;
import org.evosuite.shaded.org.hibernate.internal.SQLQueryImpl;
import org.evosuite.shaded.org.hibernate.internal.SessionFactoryImpl;
import org.evosuite.shaded.org.hibernate.jdbc.WorkExecutor;
import org.evosuite.shaded.org.hibernate.jdbc.WorkExecutorVisitable;
import org.evosuite.shaded.org.hibernate.persister.entity.EntityPersister;
import org.evosuite.shaded.org.hibernate.procedure.ProcedureCall;
import org.evosuite.shaded.org.hibernate.procedure.ProcedureCallMemento;
import org.evosuite.shaded.org.hibernate.procedure.internal.ProcedureCallImpl;
import org.evosuite.shaded.org.hibernate.type.Type;

public abstract class AbstractSessionImpl
implements Serializable,
SharedSessionContract,
SessionImplementor,
TransactionContext {
    protected transient SessionFactoryImpl factory;
    private final String tenantIdentifier;
    private boolean closed;
    private transient JdbcConnectionAccess jdbcConnectionAccess;
    private UUID sessionIdentifier;

    protected AbstractSessionImpl(SessionFactoryImpl factory, String tenantIdentifier) {
        this.factory = factory;
        this.tenantIdentifier = tenantIdentifier;
        if (MultiTenancyStrategy.NONE == factory.getSettings().getMultiTenancyStrategy()) {
            if (tenantIdentifier != null) {
                throw new HibernateException("SessionFactory was not configured for multi-tenancy");
            }
        } else if (tenantIdentifier == null) {
            throw new HibernateException("SessionFactory configured for multi-tenancy, but no tenant identifier specified");
        }
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    @Override
    public TransactionEnvironment getTransactionEnvironment() {
        return this.factory.getTransactionEnvironment();
    }

    @Override
    public <T> T execute(final LobCreationContext.Callback<T> callback) {
        return this.getTransactionCoordinator().getJdbcCoordinator().coordinateWork(new WorkExecutorVisitable<T>(){

            @Override
            public T accept(WorkExecutor<T> workExecutor, Connection connection) throws SQLException {
                try {
                    return callback.executeOnConnection(connection);
                }
                catch (SQLException e) {
                    throw AbstractSessionImpl.this.getFactory().getSQLExceptionHelper().convert(e, "Error creating contextual LOB : " + e.getMessage());
                }
            }
        });
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.factory.isClosed();
    }

    protected void setClosed() {
        this.closed = true;
    }

    protected void errorIfClosed() {
        if (this.isClosed()) {
            throw new SessionException("Session is closed!");
        }
    }

    @Override
    public Query createQuery(NamedQueryDefinition namedQueryDefinition) {
        String queryString = namedQueryDefinition.getQueryString();
        QueryImpl query = new QueryImpl(queryString, namedQueryDefinition.getFlushMode(), this, this.getHQLQueryPlan(queryString, false).getParameterMetadata());
        query.setComment("named HQL query " + namedQueryDefinition.getName());
        if (namedQueryDefinition.getLockOptions() != null) {
            query.setLockOptions(namedQueryDefinition.getLockOptions());
        }
        return query;
    }

    @Override
    public SQLQuery createSQLQuery(NamedSQLQueryDefinition namedQueryDefinition) {
        ParameterMetadata parameterMetadata = this.factory.getQueryPlanCache().getSQLParameterMetadata(namedQueryDefinition.getQueryString());
        SQLQueryImpl query = new SQLQueryImpl(namedQueryDefinition, (SessionImplementor)this, parameterMetadata);
        query.setComment("named native SQL query " + namedQueryDefinition.getName());
        return query;
    }

    @Override
    public Query getNamedQuery(String queryName) throws MappingException {
        Query query;
        this.errorIfClosed();
        NamedQueryDefinition nqd = this.factory.getNamedQuery(queryName);
        if (nqd != null) {
            query = this.createQuery(nqd);
        } else {
            NamedSQLQueryDefinition nsqlqd = this.factory.getNamedSQLQuery(queryName);
            if (nsqlqd == null) {
                throw new MappingException("Named query not known: " + queryName);
            }
            query = this.createSQLQuery(nsqlqd);
            nqd = nsqlqd;
        }
        this.initQuery(query, nqd);
        return query;
    }

    @Override
    public Query getNamedSQLQuery(String queryName) throws MappingException {
        this.errorIfClosed();
        NamedSQLQueryDefinition nsqlqd = this.factory.getNamedSQLQuery(queryName);
        if (nsqlqd == null) {
            throw new MappingException("Named SQL query not known: " + queryName);
        }
        SQLQueryImpl query = new SQLQueryImpl(nsqlqd, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(nsqlqd.getQueryString()));
        query.setComment("named native SQL query " + queryName);
        this.initQuery(query, nsqlqd);
        return query;
    }

    private void initQuery(Query query, NamedQueryDefinition nqd) {
        query.setCacheable(nqd.isCacheable());
        query.setCacheRegion(nqd.getCacheRegion());
        query.setReadOnly(nqd.isReadOnly());
        if (nqd.getTimeout() != null) {
            query.setTimeout(nqd.getTimeout());
        }
        if (nqd.getFetchSize() != null) {
            query.setFetchSize(nqd.getFetchSize());
        }
        if (nqd.getCacheMode() != null) {
            query.setCacheMode(nqd.getCacheMode());
        }
        if (nqd.getComment() != null) {
            query.setComment(nqd.getComment());
        }
        if (nqd.getFirstResult() != null) {
            query.setFirstResult(nqd.getFirstResult());
        }
        if (nqd.getMaxResults() != null) {
            query.setMaxResults(nqd.getMaxResults());
        }
        if (nqd.getFlushMode() != null) {
            query.setFlushMode(nqd.getFlushMode());
        }
    }

    @Override
    public Query createQuery(String queryString) {
        this.errorIfClosed();
        QueryImpl query = new QueryImpl(queryString, this, this.getHQLQueryPlan(queryString, false).getParameterMetadata());
        query.setComment(queryString);
        return query;
    }

    @Override
    public SQLQuery createSQLQuery(String sql) {
        this.errorIfClosed();
        SQLQueryImpl query = new SQLQueryImpl(sql, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(sql));
        query.setComment("dynamic native SQL query");
        return query;
    }

    @Override
    public ProcedureCall getNamedProcedureCall(String name) {
        this.errorIfClosed();
        ProcedureCallMemento memento = this.factory.getNamedQueryRepository().getNamedProcedureCallMemento(name);
        if (memento == null) {
            throw new IllegalArgumentException("Could not find named stored procedure call with that registration name : " + name);
        }
        ProcedureCall procedureCall = memento.makeProcedureCall(this);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName) {
        this.errorIfClosed();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SessionImplementor)this, procedureName);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName, Class ... resultClasses) {
        this.errorIfClosed();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SessionImplementor)this, procedureName, resultClasses);
        return procedureCall;
    }

    @Override
    public ProcedureCall createStoredProcedureCall(String procedureName, String ... resultSetMappings) {
        this.errorIfClosed();
        ProcedureCallImpl procedureCall = new ProcedureCallImpl((SessionImplementor)this, procedureName, resultSetMappings);
        return procedureCall;
    }

    protected HQLQueryPlan getHQLQueryPlan(String query, boolean shallow) throws HibernateException {
        return this.factory.getQueryPlanCache().getHQLQueryPlan(query, shallow, this.getEnabledFilters());
    }

    protected NativeSQLQueryPlan getNativeSQLQueryPlan(NativeSQLQuerySpecification spec) throws HibernateException {
        return this.factory.getQueryPlanCache().getNativeSQLQueryPlan(spec);
    }

    @Override
    public List list(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.listCustomQuery(this.getNativeSQLQueryPlan(spec).getCustomQuery(), queryParameters);
    }

    @Override
    public ScrollableResults scroll(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.scrollCustomQuery(this.getNativeSQLQueryPlan(spec).getCustomQuery(), queryParameters);
    }

    @Override
    public String getTenantIdentifier() {
        return this.tenantIdentifier;
    }

    @Override
    public EntityKey generateEntityKey(Serializable id, EntityPersister persister) {
        return new EntityKey(id, persister);
    }

    @Override
    public CacheKey generateCacheKey(Serializable id, Type type, String entityOrRoleName) {
        return new CacheKey(id, type, entityOrRoleName, this.getTenantIdentifier(), this.getFactory());
    }

    @Override
    public JdbcConnectionAccess getJdbcConnectionAccess() {
        if (this.jdbcConnectionAccess == null) {
            this.jdbcConnectionAccess = MultiTenancyStrategy.NONE == this.factory.getSettings().getMultiTenancyStrategy() ? new NonContextualJdbcConnectionAccess(this.getEventListenerManager(), this.factory.getServiceRegistry().getService(ConnectionProvider.class)) : new ContextualJdbcConnectionAccess(this.getEventListenerManager(), this.factory.getServiceRegistry().getService(MultiTenantConnectionProvider.class));
        }
        return this.jdbcConnectionAccess;
    }

    public UUID getSessionIdentifier() {
        if (this.sessionIdentifier == null) {
            this.sessionIdentifier = StandardRandomStrategy.INSTANCE.generateUUID(this);
        }
        return this.sessionIdentifier;
    }

    private class ContextualJdbcConnectionAccess
    implements JdbcConnectionAccess,
    Serializable {
        private final SessionEventListener listener;
        private final MultiTenantConnectionProvider connectionProvider;

        private ContextualJdbcConnectionAccess(SessionEventListener listener, MultiTenantConnectionProvider connectionProvider) {
            this.listener = listener;
            this.connectionProvider = connectionProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Connection obtainConnection() throws SQLException {
            if (AbstractSessionImpl.this.tenantIdentifier == null) {
                throw new HibernateException("Tenant identifier required!");
            }
            try {
                this.listener.jdbcConnectionAcquisitionStart();
                Connection connection = this.connectionProvider.getConnection(AbstractSessionImpl.this.tenantIdentifier);
                return connection;
            }
            finally {
                this.listener.jdbcConnectionAcquisitionEnd();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseConnection(Connection connection) throws SQLException {
            if (AbstractSessionImpl.this.tenantIdentifier == null) {
                throw new HibernateException("Tenant identifier required!");
            }
            try {
                this.listener.jdbcConnectionReleaseStart();
                this.connectionProvider.releaseConnection(AbstractSessionImpl.this.tenantIdentifier, connection);
            }
            finally {
                this.listener.jdbcConnectionReleaseEnd();
            }
        }

        @Override
        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }

    private static class NonContextualJdbcConnectionAccess
    implements JdbcConnectionAccess,
    Serializable {
        private final SessionEventListener listener;
        private final ConnectionProvider connectionProvider;

        private NonContextualJdbcConnectionAccess(SessionEventListener listener, ConnectionProvider connectionProvider) {
            this.listener = listener;
            this.connectionProvider = connectionProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Connection obtainConnection() throws SQLException {
            try {
                this.listener.jdbcConnectionAcquisitionStart();
                Connection connection = this.connectionProvider.getConnection();
                return connection;
            }
            finally {
                this.listener.jdbcConnectionAcquisitionEnd();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseConnection(Connection connection) throws SQLException {
            try {
                this.listener.jdbcConnectionReleaseStart();
                this.connectionProvider.closeConnection(connection);
            }
            finally {
                this.listener.jdbcConnectionReleaseEnd();
            }
        }

        @Override
        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }
}

