/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.internal;

import org.evosuite.shaded.org.hibernate.engine.jdbc.spi.JdbcServices;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionEnvironment;
import org.evosuite.shaded.org.hibernate.engine.transaction.spi.TransactionFactory;
import org.evosuite.shaded.org.hibernate.internal.SessionFactoryImpl;
import org.evosuite.shaded.org.hibernate.service.ServiceRegistry;
import org.evosuite.shaded.org.hibernate.stat.spi.StatisticsImplementor;

public class TransactionEnvironmentImpl
implements TransactionEnvironment {
    private final SessionFactoryImpl sessionFactory;
    private final transient StatisticsImplementor statisticsImplementor;
    private final transient ServiceRegistry serviceRegistry;
    private final transient JdbcServices jdbcServices;
    private final transient JtaPlatform jtaPlatform;
    private final transient TransactionFactory transactionFactory;

    public TransactionEnvironmentImpl(SessionFactoryImpl sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.statisticsImplementor = sessionFactory.getStatisticsImplementor();
        this.serviceRegistry = sessionFactory.getServiceRegistry();
        this.jdbcServices = this.serviceRegistry.getService(JdbcServices.class);
        this.jtaPlatform = this.serviceRegistry.getService(JtaPlatform.class);
        this.transactionFactory = this.serviceRegistry.getService(TransactionFactory.class);
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    protected ServiceRegistry serviceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public JdbcServices getJdbcServices() {
        return this.jdbcServices;
    }

    @Override
    public JtaPlatform getJtaPlatform() {
        return this.jtaPlatform;
    }

    @Override
    public TransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    @Override
    public StatisticsImplementor getStatisticsImplementor() {
        return this.statisticsImplementor;
    }
}

