/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.internal.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.evosuite.shaded.org.dom4j.Document;
import org.evosuite.shaded.org.dom4j.io.SAXReader;
import org.evosuite.shaded.org.dom4j.io.STAXEventReader;
import org.evosuite.shaded.org.hibernate.InvalidMappingException;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.internal.util.xml.BufferedXMLEventReader;
import org.evosuite.shaded.org.hibernate.internal.util.xml.ErrorLogger;
import org.evosuite.shaded.org.hibernate.internal.util.xml.FilteringXMLEventReader;
import org.evosuite.shaded.org.hibernate.internal.util.xml.LocalXmlResourceResolver;
import org.evosuite.shaded.org.hibernate.internal.util.xml.Origin;
import org.evosuite.shaded.org.hibernate.internal.util.xml.UnsupportedOrmXsdVersionException;
import org.evosuite.shaded.org.hibernate.internal.util.xml.XmlDocument;
import org.evosuite.shaded.org.hibernate.internal.util.xml.XmlDocumentImpl;
import org.evosuite.shaded.org.hibernate.internal.util.xml.XmlInfrastructureException;
import org.evosuite.shaded.org.jboss.logging.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MappingReader {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, MappingReader.class.getName());
    public static final MappingReader INSTANCE = new MappingReader();
    private XMLInputFactory staxFactory;
    private static final QName ORM_VERSION_ATTRIBUTE_QNAME = new QName("version");

    private MappingReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDocument readMappingDocument(InputSource source, Origin origin) {
        XMLEventReader staxReader = this.buildStaxEventReader(source, origin);
        try {
            XmlDocument xmlDocument = this.read(staxReader, origin);
            return xmlDocument;
        }
        finally {
            try {
                staxReader.close();
            }
            catch (Exception ignore) {}
        }
    }

    private XMLEventReader buildStaxEventReader(InputSource source, Origin origin) {
        XMLEventReader reader = null;
        if (source.getByteStream() != null) {
            try {
                reader = this.staxFactory().createXMLEventReader(source.getByteStream());
            }
            catch (XMLStreamException e) {
                throw new XmlInfrastructureException("Unable to create stax reader, origin = " + this.toLoggableString(origin), e);
            }
        }
        if (source.getCharacterStream() != null) {
            try {
                reader = this.staxFactory().createXMLEventReader(source.getCharacterStream());
            }
            catch (XMLStreamException e) {
                throw new XmlInfrastructureException("Unable to create stax reader, origin = " + this.toLoggableString(origin), e);
            }
        }
        if (reader == null) {
            throw new XmlInfrastructureException("Unable to convert SAX InputStream into StAX XMLEventReader");
        }
        return new BufferedXMLEventReader(reader);
    }

    private XMLInputFactory staxFactory() {
        if (this.staxFactory == null) {
            this.staxFactory = this.buildStaxFactory();
        }
        return this.staxFactory;
    }

    private XMLInputFactory buildStaxFactory() {
        XMLInputFactory staxFactory = XMLInputFactory.newInstance();
        staxFactory.setXMLResolver(LocalXmlResourceResolver.INSTANCE);
        return staxFactory;
    }

    private String toLoggableString(Origin origin) {
        return "[type=" + origin.getType() + ", name=" + origin.getName() + "]";
    }

    private XmlDocument read(XMLEventReader staxEventReader, Origin origin) {
        XMLEvent event;
        try {
            event = staxEventReader.peek();
            while (event != null && !event.isStartElement()) {
                staxEventReader.nextEvent();
                event = staxEventReader.peek();
            }
        }
        catch (Exception e) {
            throw new InvalidMappingException("Error accessing stax stream", origin, e);
        }
        if (event == null) {
            throw new InvalidMappingException("Could not locate root element", origin);
        }
        String rootElementName = event.asStartElement().getName().getLocalPart();
        if ("entity-mappings".equals(rootElementName)) {
            Attribute attribute = event.asStartElement().getAttributeByName(ORM_VERSION_ATTRIBUTE_QNAME);
            String explicitVersion = attribute == null ? null : attribute.getValue();
            this.validateMapping(SupportedOrmXsdVersion.parse(explicitVersion, origin), staxEventReader, origin);
        }
        return new XmlDocumentImpl(this.toDom4jDocument(staxEventReader, origin), origin);
    }

    private Document toDom4jDocument(XMLEventReader staxEventReader, Origin origin) {
        STAXEventReader dom4jStaxEventReader = new STAXEventReader();
        try {
            staxEventReader = new FilteringXMLEventReader(staxEventReader){

                @Override
                protected XMLEvent filterEvent(XMLEvent event, boolean peek) {
                    return event.getEventType() == 5 ? null : event;
                }
            };
            return dom4jStaxEventReader.readDocument(staxEventReader);
        }
        catch (XMLStreamException e) {
            throw new InvalidMappingException("Unable to read StAX source as dom4j Document for processing", origin, e);
        }
    }

    private void validateMapping(SupportedOrmXsdVersion xsdVersion, XMLEventReader staxEventReader, Origin origin) {
        StAXSource staxSource;
        Validator validator = xsdVersion.getSchema().newValidator();
        try {
            staxSource = new StAXSource(staxEventReader);
        }
        catch (XMLStreamException e) {
            throw new InvalidMappingException("Unable to generate StAXSource from mapping", origin, e);
        }
        try {
            validator.validate(staxSource);
        }
        catch (SAXException e) {
            throw new InvalidMappingException("SAXException performing validation", origin, e);
        }
        catch (IOException e) {
            throw new InvalidMappingException("IOException performing validation", origin, e);
        }
    }

    private static URL resolveLocalSchemaUrl(String schemaName) {
        URL url = MappingReader.class.getClassLoader().getResource(schemaName);
        if (url == null) {
            throw new XmlInfrastructureException("Unable to locate schema [" + schemaName + "] via classpath");
        }
        return url;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Schema resolveLocalSchema(URL schemaUrl) {
        try {
            InputStream schemaStream = schemaUrl.openStream();
            try {
                StreamSource source = new StreamSource(schemaUrl.openStream());
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(source);
                return schema;
            }
            catch (Exception e) {
                throw new XmlInfrastructureException("Unable to load schema [" + schemaUrl.toExternalForm() + "]", e);
            }
            finally {
                try {
                    schemaStream.close();
                }
                catch (IOException e) {
                    LOG.debugf("Problem closing schema stream - %s", (Object)e.toString());
                }
            }
        }
        catch (IOException e) {
            throw new XmlInfrastructureException("Stream error handling schema url [" + schemaUrl.toExternalForm() + "]");
        }
    }

    public XmlDocument readMappingDocument(EntityResolver entityResolver, InputSource source, Origin origin) {
        return this.legacyReadMappingDocument(entityResolver, source, origin);
    }

    private XmlDocument legacyReadMappingDocument(EntityResolver entityResolver, InputSource source, Origin origin) {
        ErrorLogger errorHandler = new ErrorLogger();
        SAXReader saxReader = new SAXReader();
        saxReader.setEntityResolver(entityResolver);
        saxReader.setErrorHandler(errorHandler);
        saxReader.setMergeAdjacentText(true);
        saxReader.setValidation(true);
        Document document = null;
        try {
            this.setValidationFor(saxReader, "orm_2_1.xsd");
            document = saxReader.read(source);
            if (errorHandler.hasErrors()) {
                throw errorHandler.getErrors().get(0);
            }
            return new XmlDocumentImpl(document, origin.getType(), origin.getName());
        }
        catch (Exception e) {
            Exception failure;
            block12: {
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("Problem parsing XML using orm 2.1 xsd, trying 2.0 xsd : %s", (Object)e.getMessage());
                }
                failure = e;
                errorHandler.reset();
                if (document != null) {
                    try {
                        this.setValidationFor(saxReader, "orm_2_0.xsd");
                        document = saxReader.read(new StringReader(document.asXML()));
                        if (errorHandler.hasErrors()) {
                            errorHandler.logErrors();
                            throw errorHandler.getErrors().get(0);
                        }
                        return new XmlDocumentImpl(document, origin.getType(), origin.getName());
                    }
                    catch (Exception e2) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debugf("Problem parsing XML using orm 2.0 xsd, trying 1.0 xsd : %s", (Object)e2.getMessage());
                        }
                        errorHandler.reset();
                        if (document == null) break block12;
                        try {
                            this.setValidationFor(saxReader, "orm_1_0.xsd");
                            document = saxReader.read(new StringReader(document.asXML()));
                            if (errorHandler.hasErrors()) {
                                errorHandler.logErrors();
                                throw errorHandler.getErrors().get(0);
                            }
                            return new XmlDocumentImpl(document, origin.getType(), origin.getName());
                        }
                        catch (Exception e3) {
                            if (!LOG.isDebugEnabled()) break block12;
                            LOG.debugf("Problem parsing XML using orm 1.0 xsd : %s", (Object)e3.getMessage());
                        }
                    }
                }
            }
            throw new InvalidMappingException("Unable to read XML", origin.getType(), origin.getName(), failure);
        }
    }

    private void setValidationFor(SAXReader saxReader, String xsd) {
        try {
            saxReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            if ("orm_2_1.xsd".equals(xsd)) {
                saxReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "http://xmlns.jcp.org/xml/ns/persistence/orm " + xsd);
            } else {
                saxReader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "http://java.sun.com/xml/ns/persistence/orm " + xsd);
            }
        }
        catch (SAXException e) {
            saxReader.setValidation(false);
        }
    }

    public static enum SupportedOrmXsdVersion {
        ORM_1_0("org/evosuite/shaded/org/hibernate/jpa/orm_1_0.xsd"),
        ORM_2_0("org/evosuite/shaded/org/hibernate/jpa/orm_2_0.xsd"),
        ORM_2_1("org/evosuite/shaded/org/hibernate/jpa/orm_2_1.xsd");

        private final String schemaResourceName;
        private URL schemaUrl;
        private Schema schema;

        private SupportedOrmXsdVersion(String schemaResourceName) {
            this.schemaResourceName = schemaResourceName;
        }

        public static SupportedOrmXsdVersion parse(String name, Origin origin) {
            if ("1.0".equals(name)) {
                return ORM_1_0;
            }
            if ("2.0".equals(name)) {
                return ORM_2_0;
            }
            if ("2.1".equals(name)) {
                return ORM_2_1;
            }
            throw new UnsupportedOrmXsdVersionException(name, origin);
        }

        public URL getSchemaUrl() {
            if (this.schemaUrl == null) {
                this.schemaUrl = MappingReader.resolveLocalSchemaUrl(this.schemaResourceName);
            }
            return this.schemaUrl;
        }

        public Schema getSchema() {
            if (this.schema == null) {
                this.schema = MappingReader.resolveLocalSchema(this.getSchemaUrl());
            }
            return this.schema;
        }
    }
}

