/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.jpa.boot.scan.spi;

import org.evosuite.shaded.org.hibernate.jpa.boot.archive.spi.ArchiveContext;
import org.evosuite.shaded.org.hibernate.jpa.boot.archive.spi.ArchiveEntry;
import org.evosuite.shaded.org.hibernate.jpa.boot.archive.spi.ArchiveEntryHandler;
import org.evosuite.shaded.org.hibernate.jpa.boot.internal.MappingFileDescriptorImpl;
import org.evosuite.shaded.org.hibernate.jpa.boot.scan.spi.ScanOptions;
import org.evosuite.shaded.org.hibernate.jpa.boot.spi.MappingFileDescriptor;

public class NonClassFileArchiveEntryHandler
implements ArchiveEntryHandler {
    private final ScanOptions scanOptions;
    private final Callback callback;

    public NonClassFileArchiveEntryHandler(ScanOptions scanOptions, Callback callback) {
        this.scanOptions = scanOptions;
        this.callback = callback;
    }

    @Override
    public void handleEntry(ArchiveEntry entry, ArchiveContext context) {
        if (this.acceptAsMappingFile(entry, context)) {
            this.notifyMatchedMappingFile(entry);
        }
    }

    private boolean acceptAsMappingFile(ArchiveEntry entry, ArchiveContext context) {
        if (entry.getNameWithinArchive().endsWith("hbm.xml")) {
            return this.scanOptions.canDetectHibernateMappingFiles();
        }
        if (entry.getNameWithinArchive().endsWith("META-INF/orm.xml")) {
            if (context.getPersistenceUnitDescriptor().getMappingFileNames().contains("META-INF/orm.xml")) {
                return context.isRootUrl();
            }
            return true;
        }
        return context.getPersistenceUnitDescriptor().getMappingFileNames().contains(entry.getNameWithinArchive());
    }

    protected final void notifyMatchedMappingFile(ArchiveEntry entry) {
        this.callback.locatedMappingFile(this.toMappingFileDescriptor(entry));
    }

    protected MappingFileDescriptor toMappingFileDescriptor(ArchiveEntry entry) {
        return new MappingFileDescriptorImpl(entry.getNameWithinArchive(), entry.getStreamAccess());
    }

    public static interface Callback {
        public void locatedMappingFile(MappingFileDescriptor var1);
    }
}

