/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.jpa.event.internal.core;

import org.evosuite.shaded.org.hibernate.SessionFactory;
import org.evosuite.shaded.org.hibernate.engine.spi.EntityEntry;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.Status;
import org.evosuite.shaded.org.hibernate.event.internal.DefaultFlushEntityEventListener;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.jpa.CallbackRegistryConsumer;
import org.evosuite.shaded.org.hibernate.jpa.event.spi.jpa.CallbackRegistry;
import org.evosuite.shaded.org.hibernate.metadata.ClassMetadata;
import org.evosuite.shaded.org.hibernate.persister.entity.EntityPersister;
import org.evosuite.shaded.org.hibernate.type.Type;

public class JpaFlushEntityEventListener
extends DefaultFlushEntityEventListener
implements CallbackRegistryConsumer {
    private CallbackRegistry callbackRegistry;

    @Override
    public void injectCallbackRegistry(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    public JpaFlushEntityEventListener() {
    }

    public JpaFlushEntityEventListener(CallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    @Override
    protected boolean invokeInterceptor(SessionImplementor session, Object entity, EntityEntry entry, Object[] values, EntityPersister persister) {
        boolean isDirty = false;
        if (entry.getStatus() != Status.DELETED && this.callbackRegistry.preUpdate(entity)) {
            isDirty = this.copyState(entity, persister.getPropertyTypes(), values, session.getFactory());
        }
        return super.invokeInterceptor(session, entity, entry, values, persister) || isDirty;
    }

    private boolean copyState(Object entity, Type[] types, Object[] state, SessionFactory sf) {
        ClassMetadata metadata = sf.getClassMetadata(entity.getClass());
        Object[] newState = metadata.getPropertyValues(entity);
        int size = newState.length;
        boolean isDirty = false;
        for (int index = 0; index < size; ++index) {
            if (types[index].isEqual(state[index], newState[index])) continue;
            isDirty = true;
            state[index] = newState[index];
        }
        return isDirty;
    }
}

