/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.jpa.event.internal.jpa;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.evosuite.shaded.org.hibernate.jpa.event.spi.jpa.ListenerFactory;

public class BeanManagerListenerFactory
implements ListenerFactory {
    private final BeanManager beanManager;
    private final Map<Class, BeanMetaData> listeners = new ConcurrentHashMap<Class, BeanMetaData>();

    public static BeanManagerListenerFactory fromBeanManagerReference(Object beanManagerReference) {
        return new BeanManagerListenerFactory((BeanManager)beanManagerReference);
    }

    public BeanManagerListenerFactory(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    @Override
    public <T> T buildListener(Class<T> listenerClass) {
        BeanMetaData beanMetaData = this.listeners.get(listenerClass);
        if (beanMetaData == null) {
            beanMetaData = new BeanMetaData(listenerClass);
            this.listeners.put(listenerClass, beanMetaData);
        }
        return (T)beanMetaData.instance;
    }

    @Override
    public void release() {
        for (BeanMetaData beanMetaData : this.listeners.values()) {
            beanMetaData.release();
        }
        this.listeners.clear();
    }

    private class BeanMetaData<T> {
        private final InjectionTarget<T> injectionTarget;
        private final CreationalContext<T> creationalContext;
        private final T instance;

        private BeanMetaData(Class<T> listenerClass) {
            AnnotatedType<T> annotatedType = BeanManagerListenerFactory.this.beanManager.createAnnotatedType(listenerClass);
            this.injectionTarget = BeanManagerListenerFactory.this.beanManager.createInjectionTarget(annotatedType);
            this.creationalContext = BeanManagerListenerFactory.this.beanManager.createCreationalContext(null);
            this.instance = this.injectionTarget.produce(this.creationalContext);
            this.injectionTarget.inject(this.instance, this.creationalContext);
            this.injectionTarget.postConstruct(this.instance);
        }

        private void release() {
            this.injectionTarget.preDestroy(this.instance);
            this.injectionTarget.dispose(this.instance);
            this.creationalContext.release();
        }
    }
}

