/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.jpa.event.spi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.evosuite.shaded.org.hibernate.cfg.Configuration;
import org.evosuite.shaded.org.hibernate.engine.spi.CascadeStyles;
import org.evosuite.shaded.org.hibernate.engine.spi.CascadingAction;
import org.evosuite.shaded.org.hibernate.engine.spi.CascadingActions;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.event.service.spi.DuplicationStrategy;
import org.evosuite.shaded.org.hibernate.event.service.spi.EventListenerGroup;
import org.evosuite.shaded.org.hibernate.event.service.spi.EventListenerRegistry;
import org.evosuite.shaded.org.hibernate.event.spi.EventType;
import org.evosuite.shaded.org.hibernate.integrator.spi.Integrator;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.core.HibernateEntityManagerEventListener;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.core.JpaAutoFlushEventListener;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.core.JpaDeleteEventListener;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.core.JpaFlushEntityEventListener;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.core.JpaFlushEventListener;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.core.JpaMergeEventListener;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.core.JpaPersistEventListener;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.core.JpaPersistOnFlushEventListener;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.core.JpaPostDeleteEventListener;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.core.JpaPostInsertEventListener;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.core.JpaPostLoadEventListener;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.core.JpaPostUpdateEventListener;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.core.JpaSaveEventListener;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.core.JpaSaveOrUpdateEventListener;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.jpa.CallbackProcessor;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.jpa.CallbackProcessorImpl;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.jpa.CallbackRegistryConsumer;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.jpa.CallbackRegistryImpl;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.jpa.LegacyCallbackProcessor;
import org.evosuite.shaded.org.hibernate.jpa.event.internal.jpa.StandardListenerFactory;
import org.evosuite.shaded.org.hibernate.jpa.event.spi.jpa.ListenerFactory;
import org.evosuite.shaded.org.hibernate.mapping.PersistentClass;
import org.evosuite.shaded.org.hibernate.metamodel.binding.EntityBinding;
import org.evosuite.shaded.org.hibernate.metamodel.source.MetadataImplementor;
import org.evosuite.shaded.org.hibernate.service.spi.ServiceRegistryImplementor;
import org.evosuite.shaded.org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class JpaIntegrator
implements Integrator {
    private ListenerFactory jpaListenerFactory;
    private CallbackProcessor callbackProcessor;
    private CallbackRegistryImpl callbackRegistry;
    private static final DuplicationStrategy JPA_DUPLICATION_STRATEGY = new JPADuplicationStrategy();
    private static final String CDI_LISTENER_FACTORY_CLASS = "org.evosuite.shaded.org.hibernate.jpa.event.internal.jpa.BeanManagerListenerFactory";

    @Override
    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        CascadeStyles.registerCascadeStyle("persist", new PersistCascadeStyle());
        EventListenerRegistry eventListenerRegistry = serviceRegistry.getService(EventListenerRegistry.class);
        eventListenerRegistry.addDuplicationStrategy(JPA_DUPLICATION_STRATEGY);
        eventListenerRegistry.setListeners(EventType.AUTO_FLUSH, JpaAutoFlushEventListener.INSTANCE);
        eventListenerRegistry.setListeners(EventType.DELETE, new JpaDeleteEventListener());
        eventListenerRegistry.setListeners(EventType.FLUSH_ENTITY, new JpaFlushEntityEventListener());
        eventListenerRegistry.setListeners(EventType.FLUSH, JpaFlushEventListener.INSTANCE);
        eventListenerRegistry.setListeners(EventType.MERGE, new JpaMergeEventListener());
        eventListenerRegistry.setListeners(EventType.PERSIST, new JpaPersistEventListener());
        eventListenerRegistry.setListeners(EventType.PERSIST_ONFLUSH, new JpaPersistOnFlushEventListener());
        eventListenerRegistry.setListeners(EventType.SAVE, new JpaSaveEventListener());
        eventListenerRegistry.setListeners(EventType.SAVE_UPDATE, new JpaSaveOrUpdateEventListener());
        eventListenerRegistry.prependListeners(EventType.POST_DELETE, new JpaPostDeleteEventListener());
        eventListenerRegistry.prependListeners(EventType.POST_INSERT, new JpaPostInsertEventListener());
        eventListenerRegistry.prependListeners(EventType.POST_LOAD, new JpaPostLoadEventListener());
        eventListenerRegistry.prependListeners(EventType.POST_UPDATE, new JpaPostUpdateEventListener());
        for (Map.Entry<Object, Object> entry : configuration.getProperties().entrySet()) {
            String propertyName;
            if (!String.class.isInstance(entry.getKey()) || !(propertyName = (String)entry.getKey()).startsWith("hibernate.ejb.event")) continue;
            String eventTypeName = propertyName.substring("hibernate.ejb.event".length() + 1);
            EventType eventType = EventType.resolveEventTypeByName(eventTypeName);
            EventListenerGroup<Object> eventListenerGroup = eventListenerRegistry.getEventListenerGroup(eventType);
            for (String listenerImpl : ((String)entry.getValue()).split(" ,")) {
                eventListenerGroup.appendListener(this.instantiate(listenerImpl, serviceRegistry));
            }
        }
        this.callbackRegistry = new CallbackRegistryImpl();
        Object beanManagerRef = configuration.getProperties().get("javax.persistence.bean.manager");
        this.jpaListenerFactory = beanManagerRef == null ? new StandardListenerFactory() : this.buildBeanManagerListenerFactory(beanManagerRef);
        this.callbackProcessor = new LegacyCallbackProcessor(this.jpaListenerFactory, configuration.getReflectionManager());
        Iterator<PersistentClass> classes = configuration.getClassMappings();
        while (classes.hasNext()) {
            PersistentClass clazz = classes.next();
            if (clazz.getClassName() == null) continue;
            this.callbackProcessor.processCallbacksForEntity(clazz.getClassName(), this.callbackRegistry);
        }
        for (EventType eventType : EventType.values()) {
            EventListenerGroup eventListenerGroup = eventListenerRegistry.getEventListenerGroup(eventType);
            for (Object listener : eventListenerGroup.listeners()) {
                if (!CallbackRegistryConsumer.class.isInstance(listener)) continue;
                ((CallbackRegistryConsumer)listener).injectCallbackRegistry(this.callbackRegistry);
            }
        }
    }

    private ListenerFactory buildBeanManagerListenerFactory(Object beanManagerRef) {
        try {
            Class<?> beanManagerListenerFactoryClass = this.getClass().getClassLoader().loadClass(CDI_LISTENER_FACTORY_CLASS);
            Method beanManagerListenerFactoryBuilderMethod = beanManagerListenerFactoryClass.getMethod("fromBeanManagerReference", Object.class);
            try {
                return (ListenerFactory)beanManagerListenerFactoryBuilderMethod.invoke(null, beanManagerRef);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        catch (ClassNotFoundException e) {
            throw new HibernateException("Could not locate BeanManagerListenerFactory class to handle CDI extensions", e);
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new HibernateException("Could not access BeanManagerListenerFactory class to handle CDI extensions", e);
        }
    }

    @Override
    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        CascadeStyles.registerCascadeStyle("persist", new PersistCascadeStyle());
        EventListenerRegistry eventListenerRegistry = serviceRegistry.getService(EventListenerRegistry.class);
        eventListenerRegistry.addDuplicationStrategy(JPA_DUPLICATION_STRATEGY);
        eventListenerRegistry.setListeners(EventType.AUTO_FLUSH, JpaAutoFlushEventListener.INSTANCE);
        eventListenerRegistry.setListeners(EventType.DELETE, new JpaDeleteEventListener());
        eventListenerRegistry.setListeners(EventType.FLUSH_ENTITY, new JpaFlushEntityEventListener());
        eventListenerRegistry.setListeners(EventType.FLUSH, JpaFlushEventListener.INSTANCE);
        eventListenerRegistry.setListeners(EventType.MERGE, new JpaMergeEventListener());
        eventListenerRegistry.setListeners(EventType.PERSIST, new JpaPersistEventListener());
        eventListenerRegistry.setListeners(EventType.PERSIST_ONFLUSH, new JpaPersistOnFlushEventListener());
        eventListenerRegistry.setListeners(EventType.SAVE, new JpaSaveEventListener());
        eventListenerRegistry.setListeners(EventType.SAVE_UPDATE, new JpaSaveOrUpdateEventListener());
        eventListenerRegistry.prependListeners(EventType.POST_DELETE, new JpaPostDeleteEventListener());
        eventListenerRegistry.prependListeners(EventType.POST_INSERT, new JpaPostInsertEventListener());
        eventListenerRegistry.prependListeners(EventType.POST_LOAD, new JpaPostLoadEventListener());
        eventListenerRegistry.prependListeners(EventType.POST_UPDATE, new JpaPostUpdateEventListener());
        for (Map.Entry<Object, Object> entry : sessionFactory.getProperties().entrySet()) {
            String propertyName;
            if (!String.class.isInstance(entry.getKey()) || !(propertyName = (String)entry.getKey()).startsWith("hibernate.ejb.event")) continue;
            String eventTypeName = propertyName.substring("hibernate.ejb.event".length() + 1);
            EventType eventType = EventType.resolveEventTypeByName(eventTypeName);
            EventListenerGroup<Object> eventListenerGroup = eventListenerRegistry.getEventListenerGroup(eventType);
            for (String listenerImpl : ((String)entry.getValue()).split(" ,")) {
                eventListenerGroup.appendListener(this.instantiate(listenerImpl, serviceRegistry));
            }
        }
        this.callbackRegistry = new CallbackRegistryImpl();
        Object beanManagerRef = sessionFactory.getProperties().get("javax.persistence.bean.manager");
        this.jpaListenerFactory = beanManagerRef == null ? new StandardListenerFactory() : this.buildBeanManagerListenerFactory(beanManagerRef);
        this.callbackProcessor = new CallbackProcessorImpl(this.jpaListenerFactory, metadata, serviceRegistry);
        for (EntityBinding binding : metadata.getEntityBindings()) {
            this.callbackProcessor.processCallbacksForEntity(binding, this.callbackRegistry);
        }
        for (EventType eventType : EventType.values()) {
            EventListenerGroup eventListenerGroup = eventListenerRegistry.getEventListenerGroup(eventType);
            for (Object listener : eventListenerGroup.listeners()) {
                if (!CallbackRegistryConsumer.class.isInstance(listener)) continue;
                ((CallbackRegistryConsumer)listener).injectCallbackRegistry(this.callbackRegistry);
            }
        }
    }

    @Override
    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        if (this.callbackRegistry != null) {
            this.callbackRegistry.release();
        }
        if (this.callbackProcessor != null) {
            this.callbackProcessor.release();
        }
        if (this.jpaListenerFactory != null) {
            this.jpaListenerFactory.release();
        }
    }

    private Object instantiate(String listenerImpl, ServiceRegistryImplementor serviceRegistry) {
        try {
            return serviceRegistry.getService(ClassLoaderService.class).classForName(listenerImpl).newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate requested listener [" + listenerImpl + "]", e);
        }
    }

    private static class JPADuplicationStrategy
    implements DuplicationStrategy {
        private JPADuplicationStrategy() {
        }

        @Override
        public boolean areMatch(Object listener, Object original) {
            return listener.getClass().equals(original.getClass()) && HibernateEntityManagerEventListener.class.isInstance(original);
        }

        @Override
        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.KEEP_ORIGINAL;
        }
    }

    private static class PersistCascadeStyle
    extends CascadeStyles.BaseCascadeStyle {
        private PersistCascadeStyle() {
        }

        @Override
        public boolean doCascade(CascadingAction action) {
            return action == JpaPersistEventListener.PERSIST_SKIPLAZY || action == CascadingActions.PERSIST_ON_FLUSH;
        }

        public String toString() {
            return "STYLE_PERSIST_SKIPLAZY";
        }
    }
}

