/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.jpa.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManagerFactory;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class EntityManagerFactoryRegistry {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, EntityManagerFactoryRegistry.class.getName());
    public static final EntityManagerFactoryRegistry INSTANCE = new EntityManagerFactoryRegistry();
    private final ConcurrentHashMap<String, Set<EntityManagerFactory>> entityManagerFactoryMap = new ConcurrentHashMap();

    public EntityManagerFactoryRegistry() {
        LOG.debugf("Initializing EntityManagerFactoryRegistry : %s", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntityManagerFactory(String name, EntityManagerFactory entityManagerFactory) {
        LOG.debugf("Registering EntityManagerFactory: %s ", (Object)name);
        if (name == null) {
            LOG.tracef("not registering EntityManagerFactory because name is null", new Object[0]);
            return;
        }
        HashSet<EntityManagerFactory> entityManagerFactorySet = new HashSet<EntityManagerFactory>();
        entityManagerFactorySet.add(entityManagerFactory);
        Set<EntityManagerFactory> previous = this.entityManagerFactoryMap.putIfAbsent(name, entityManagerFactorySet);
        if (previous != null) {
            LOG.entityManagerFactoryAlreadyRegistered(name, "hibernate.ejb.entitymanager_factory_name");
            boolean done = false;
            while (!done) {
                Set<EntityManagerFactory> set = previous;
                synchronized (set) {
                    if (this.entityManagerFactoryMap.get(name) == previous) {
                        previous.add(entityManagerFactory);
                        done = true;
                    } else {
                        previous = this.entityManagerFactoryMap.get(name);
                        if (null == previous) {
                            this.entityManagerFactoryMap.putIfAbsent(name, new HashSet());
                            previous = this.entityManagerFactoryMap.get(name);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntityManagerFactory(String name, EntityManagerFactory entityManagerFactory) throws HibernateException {
        LOG.debugf("Remove: name=%s", (Object)name);
        if (name == null) {
            LOG.tracef("not removing EntityManagerFactory from registry because name is null", new Object[0]);
            return;
        }
        Set<EntityManagerFactory> entityManagerFactorySet = this.entityManagerFactoryMap.get(name);
        if (entityManagerFactorySet == null) {
            throw new HibernateException("registry does not contain entity manager factory: " + name);
        }
        Set<EntityManagerFactory> set = entityManagerFactorySet;
        synchronized (set) {
            boolean removed = entityManagerFactorySet.remove(entityManagerFactory);
            if (entityManagerFactorySet.size() == 0) {
                this.entityManagerFactoryMap.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory getNamedEntityManagerFactory(String name) throws HibernateException {
        LOG.debugf("Lookup: name=%s", (Object)name);
        Set<EntityManagerFactory> entityManagerFactorySet = this.entityManagerFactoryMap.get(name);
        if (entityManagerFactorySet == null) {
            throw new HibernateException("registry does not contain entity manager factory: " + name);
        }
        Set<EntityManagerFactory> set = entityManagerFactorySet;
        synchronized (set) {
            if (entityManagerFactorySet.size() > 1) {
                throw new HibernateException("registry contains more than one (" + entityManagerFactorySet.size() + ") entity manager factories: " + name);
            }
            return entityManagerFactorySet.iterator().next();
        }
    }
}

