/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.jpa.internal;

import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.Session;
import org.evosuite.shaded.org.hibernate.Transaction;
import org.evosuite.shaded.org.hibernate.jpa.spi.AbstractEntityManagerImpl;
import org.evosuite.shaded.org.hibernate.jpa.spi.HibernateEntityManagerImplementor;

public class TransactionImpl
implements EntityTransaction {
    private HibernateEntityManagerImplementor entityManager;
    private Transaction tx;
    private boolean rollbackOnly;

    public TransactionImpl(AbstractEntityManagerImpl entityManager) {
        this.entityManager = entityManager;
    }

    private Session getSession() {
        return this.entityManager.getSession();
    }

    @Override
    public void begin() {
        try {
            this.rollbackOnly = false;
            if (this.tx != null && this.tx.isActive()) {
                throw new IllegalStateException("Transaction already active");
            }
            this.tx = this.getSession().beginTransaction();
        }
        catch (HibernateException he) {
            this.entityManager.throwPersistenceException(he);
        }
    }

    @Override
    public void commit() {
        if (this.tx == null || !this.tx.isActive()) {
            throw new IllegalStateException("Transaction not active");
        }
        if (this.rollbackOnly) {
            this.tx.rollback();
            throw new RollbackException("Transaction marked as rollbackOnly");
        }
        try {
            this.tx.commit();
        }
        catch (Exception e) {
            Exception wrappedException = e instanceof HibernateException ? this.entityManager.convert((HibernateException)e) : e;
            try {
                this.tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RollbackException("Error while committing the transaction", wrappedException);
        }
        finally {
            this.rollbackOnly = false;
        }
    }

    @Override
    public void rollback() {
        if (this.tx == null || !this.tx.isActive()) {
            throw new IllegalStateException("Transaction not active");
        }
        try {
            this.tx.rollback();
        }
        catch (Exception e) {
            throw new PersistenceException("unexpected error when rollbacking", e);
        }
        finally {
            try {
                Session session;
                if (this.entityManager != null && (session = this.getSession()) != null && session.isOpen()) {
                    session.clear();
                }
            }
            catch (Throwable throwable) {}
            this.rollbackOnly = false;
        }
    }

    @Override
    public void setRollbackOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException("Transaction not active");
        }
        this.rollbackOnly = true;
    }

    @Override
    public boolean getRollbackOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException("Transaction not active");
        }
        return this.rollbackOnly;
    }

    @Override
    public boolean isActive() {
        try {
            return this.tx != null && this.tx.isActive();
        }
        catch (RuntimeException e) {
            throw new PersistenceException("unexpected error when checking transaction status", e);
        }
    }
}

