/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.jpa.internal.instrument;

import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.shaded.org.hibernate.bytecode.buildtime.spi.ClassFilter;
import org.evosuite.shaded.org.hibernate.bytecode.buildtime.spi.FieldFilter;
import org.evosuite.shaded.org.hibernate.bytecode.spi.ClassTransformer;
import org.evosuite.shaded.org.hibernate.cfg.Environment;

public class InterceptFieldClassFileTransformer
implements javax.persistence.spi.ClassTransformer {
    private ClassTransformer classTransformer;

    public InterceptFieldClassFileTransformer(List<String> entities) {
        final ArrayList<String> copyEntities = new ArrayList<String>(entities.size());
        copyEntities.addAll(entities);
        this.classTransformer = Environment.getBytecodeProvider().getTransformer(new ClassFilter(){

            @Override
            public boolean shouldInstrumentClass(String className) {
                return copyEntities.contains(className);
            }
        }, new FieldFilter(){

            @Override
            public boolean shouldInstrumentField(String className, String fieldName) {
                return true;
            }

            @Override
            public boolean shouldTransformFieldAccess(String transformingClassName, String fieldOwnerClassName, String fieldName) {
                return true;
            }
        });
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            return this.classTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
        }
        catch (Exception e) {
            throw new IllegalClassFormatException(e.getMessage());
        }
    }
}

