/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.jpa.internal.metamodel;

import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.jpa.internal.metamodel.EmbeddableTypeImpl;
import org.evosuite.shaded.org.hibernate.persister.entity.EntityPersister;
import org.evosuite.shaded.org.hibernate.type.CompositeType;
import org.evosuite.shaded.org.hibernate.type.Type;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class Helper {
    private static final Logger log = Logger.getLogger(Helper.class);
    private final SessionFactoryImplementor sessionFactory;

    public Helper(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public AttributeSource resolveAttributeSource(ManagedType managedType) {
        return Helper.resolveAttributeSource(this.sessionFactory, managedType);
    }

    public static AttributeSource resolveAttributeSource(SessionFactoryImplementor sessionFactory, ManagedType managedType) {
        if (EmbeddableTypeImpl.class.isInstance(managedType)) {
            return new ComponentAttributeSource(((EmbeddableTypeImpl)managedType).getHibernateType());
        }
        if (IdentifiableType.class.isInstance(managedType)) {
            String entityName = managedType.getJavaType().getName();
            log.debugf("Attempting to resolve managed type as entity using %s", (Object)entityName);
            return new EntityPersisterAttributeSource(sessionFactory.getEntityPersister(entityName));
        }
        throw new IllegalArgumentException(String.format("Unknown ManagedType implementation [%s]", managedType.getClass()));
    }

    public Type resolveType(Attribute attribute) {
        return Helper.resolveType(this.sessionFactory, attribute);
    }

    public static Type resolveType(SessionFactoryImplementor sessionFactory, Attribute attribute) {
        return Helper.resolveAttributeSource(sessionFactory, attribute.getDeclaringType()).findType(attribute.getName());
    }

    public static class ComponentAttributeSource
    implements AttributeSource {
        private final CompositeType compositeType;

        public ComponentAttributeSource(CompositeType compositeType) {
            this.compositeType = compositeType;
        }

        @Override
        public Type findType(String attributeName) {
            int i = 0;
            for (String componentAttributeName : this.compositeType.getPropertyNames()) {
                if (attributeName.equals(componentAttributeName)) {
                    return this.compositeType.getSubtypes()[i];
                }
                ++i;
            }
            throw new IllegalArgumentException("Could not find given attribute name [%s] on composite-type");
        }
    }

    public static class EntityPersisterAttributeSource
    implements AttributeSource {
        private final EntityPersister entityPersister;

        public EntityPersisterAttributeSource(EntityPersister entityPersister) {
            this.entityPersister = entityPersister;
        }

        @Override
        public Type findType(String attributeName) {
            return this.entityPersister.getPropertyType(attributeName);
        }
    }

    public static interface AttributeSource {
        public Type findType(String var1);
    }
}

