/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.jpa.internal.schemagen;

import java.sql.SQLException;
import java.sql.Statement;
import javax.persistence.PersistenceException;
import org.evosuite.shaded.org.hibernate.jpa.SchemaGenAction;
import org.evosuite.shaded.org.hibernate.jpa.internal.schemagen.GenerationTarget;
import org.evosuite.shaded.org.hibernate.jpa.internal.schemagen.JdbcConnectionContext;
import org.evosuite.shaded.org.jboss.logging.Logger;

class GenerationTargetToDatabase
implements GenerationTarget {
    private static final Logger log = Logger.getLogger(GenerationTargetToDatabase.class);
    private final JdbcConnectionContext jdbcConnectionContext;
    private final SchemaGenAction databaseAction;
    private Statement jdbcStatement;

    GenerationTargetToDatabase(JdbcConnectionContext jdbcConnectionContext, SchemaGenAction databaseAction) {
        this.jdbcConnectionContext = jdbcConnectionContext;
        this.databaseAction = databaseAction;
    }

    @Override
    public void acceptCreateCommands(Iterable<String> commands) {
        if (!this.databaseAction.includesCreate()) {
            return;
        }
        for (String command : commands) {
            try {
                this.jdbcConnectionContext.logSqlStatement(command);
                this.jdbcStatement().execute(command);
            }
            catch (SQLException e) {
                throw new PersistenceException("Unable to execute JPA schema generation create command [" + command + "]", e);
            }
        }
    }

    private Statement jdbcStatement() {
        if (this.jdbcStatement == null) {
            try {
                this.jdbcStatement = this.jdbcConnectionContext.getJdbcConnection().createStatement();
            }
            catch (SQLException e) {
                throw new PersistenceException("Unable to generate JDBC Statement object for schema generation");
            }
        }
        return this.jdbcStatement;
    }

    @Override
    public void acceptDropCommands(Iterable<String> commands) {
        if (!this.databaseAction.includesDrop()) {
            return;
        }
        for (String command : commands) {
            try {
                this.jdbcConnectionContext.logSqlStatement(command);
                this.jdbcStatement().execute(command);
            }
            catch (SQLException e) {
                log.warnf("Unable to execute JPA schema generation drop command [" + command + "]", (Object)e);
            }
        }
    }

    @Override
    public void release() {
        if (this.jdbcStatement != null) {
            try {
                this.jdbcStatement.close();
            }
            catch (SQLException e) {
                log.debug("Unable to close JDBC statement after JPA schema generation : " + e.toString());
            }
        }
    }
}

