/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.jpa.internal.schemagen;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.persistence.PersistenceException;
import org.evosuite.shaded.org.hibernate.jpa.internal.HEMLogging;
import org.evosuite.shaded.org.hibernate.jpa.internal.schemagen.ScriptTargetOutput;
import org.evosuite.shaded.org.hibernate.jpa.internal.schemagen.ScriptTargetOutputToWriter;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class ScriptTargetOutputToFile
extends ScriptTargetOutputToWriter
implements ScriptTargetOutput {
    private static final Logger log = HEMLogging.logger(ScriptTargetOutputToFile.class);

    public ScriptTargetOutputToFile(File file) {
        super(ScriptTargetOutputToFile.toFileWriter(file));
    }

    @Override
    public void release() {
        try {
            this.writer().close();
        }
        catch (IOException e) {
            throw new PersistenceException("Unable to close file writer : " + e.toString());
        }
    }

    static Writer toFileWriter(File file) {
        try {
            if (!file.exists()) {
                log.debug("Attempting to create non-existent script target file : " + file.getAbsolutePath());
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
        }
        catch (Exception e) {
            log.debug("Exception calling File#createNewFile : " + e.toString());
        }
        try {
            return new FileWriter(file);
        }
        catch (IOException e) {
            throw new PersistenceException("Unable to open specified script target file for writing : " + file, e);
        }
    }
}

