/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.loader.collection.plan;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.evosuite.shaded.org.hibernate.AssertionFailure;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.engine.spi.QueryParameters;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.internal.CoreMessageLogger;
import org.evosuite.shaded.org.hibernate.loader.collection.CollectionInitializer;
import org.evosuite.shaded.org.hibernate.loader.plan.build.internal.FetchStyleLoadPlanBuildingAssociationVisitationStrategy;
import org.evosuite.shaded.org.hibernate.loader.plan.build.spi.MetamodelDrivenLoadPlanBuilder;
import org.evosuite.shaded.org.hibernate.loader.plan.exec.internal.AbstractLoadPlanBasedLoader;
import org.evosuite.shaded.org.hibernate.loader.plan.exec.internal.BatchingLoadQueryDetailsFactory;
import org.evosuite.shaded.org.hibernate.loader.plan.exec.query.spi.QueryBuildingParameters;
import org.evosuite.shaded.org.hibernate.loader.plan.exec.spi.LoadQueryDetails;
import org.evosuite.shaded.org.hibernate.loader.plan.spi.LoadPlan;
import org.evosuite.shaded.org.hibernate.persister.collection.CollectionPersister;
import org.evosuite.shaded.org.hibernate.persister.collection.QueryableCollection;
import org.evosuite.shaded.org.hibernate.pretty.MessageHelper;
import org.evosuite.shaded.org.hibernate.type.Type;

public abstract class AbstractLoadPlanBasedCollectionInitializer
extends AbstractLoadPlanBasedLoader
implements CollectionInitializer {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(AbstractLoadPlanBasedCollectionInitializer.class);
    private final QueryableCollection collectionPersister;
    private final LoadQueryDetails staticLoadQuery;

    public AbstractLoadPlanBasedCollectionInitializer(QueryableCollection collectionPersister, QueryBuildingParameters buildingParameters) {
        super(collectionPersister.getFactory());
        this.collectionPersister = collectionPersister;
        FetchStyleLoadPlanBuildingAssociationVisitationStrategy strategy = new FetchStyleLoadPlanBuildingAssociationVisitationStrategy(collectionPersister.getFactory(), buildingParameters.getQueryInfluencers(), buildingParameters.getLockMode() != null ? buildingParameters.getLockMode() : buildingParameters.getLockOptions().getLockMode());
        LoadPlan plan = MetamodelDrivenLoadPlanBuilder.buildRootCollectionLoadPlan(strategy, collectionPersister);
        this.staticLoadQuery = BatchingLoadQueryDetailsFactory.makeCollectionLoadQueryDetails(collectionPersister, plan, buildingParameters);
    }

    @Override
    public void initialize(Serializable id, SessionImplementor session) throws HibernateException {
        if (log.isDebugEnabled()) {
            log.debugf("Loading collection: %s", (Object)MessageHelper.collectionInfoString((CollectionPersister)this.collectionPersister, id, this.getFactory()));
        }
        Object[] ids = new Serializable[]{id};
        try {
            QueryParameters qp = new QueryParameters();
            qp.setPositionalParameterTypes(new Type[]{this.collectionPersister.getKeyType()});
            qp.setPositionalParameterValues(ids);
            qp.setCollectionKeys((Serializable[])ids);
            this.executeLoad(session, qp, this.staticLoadQuery, true, null);
        }
        catch (SQLException sqle) {
            throw this.getFactory().getSQLExceptionHelper().convert(sqle, "could not initialize a collection: " + MessageHelper.collectionInfoString((CollectionPersister)this.collectionPersister, id, this.getFactory()), this.staticLoadQuery.getSqlStatement());
        }
        log.debug("Done loading collection");
    }

    protected QueryableCollection collectionPersister() {
        return this.collectionPersister;
    }

    @Override
    protected LoadQueryDetails getStaticLoadQuery() {
        return this.staticLoadQuery;
    }

    @Override
    protected int[] getNamedParameterLocs(String name) {
        throw new AssertionFailure("no named parameters");
    }

    @Override
    protected void autoDiscoverTypes(ResultSet rs) {
        throw new AssertionFailure("Auto discover types not supported in this loader");
    }
}

