/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.loader.entity;

import java.io.Serializable;
import java.util.List;
import org.evosuite.shaded.org.hibernate.LockMode;
import org.evosuite.shaded.org.hibernate.LockOptions;
import org.evosuite.shaded.org.hibernate.engine.spi.LoadQueryInfluencers;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionImplementor;
import org.evosuite.shaded.org.hibernate.internal.util.collections.ArrayHelper;
import org.evosuite.shaded.org.hibernate.loader.Loader;
import org.evosuite.shaded.org.hibernate.loader.entity.BatchingEntityLoader;
import org.evosuite.shaded.org.hibernate.loader.entity.BatchingEntityLoaderBuilder;
import org.evosuite.shaded.org.hibernate.loader.entity.EntityLoader;
import org.evosuite.shaded.org.hibernate.loader.entity.UniqueEntityLoader;
import org.evosuite.shaded.org.hibernate.persister.entity.OuterJoinLoadable;

public class LegacyBatchingEntityLoaderBuilder
extends BatchingEntityLoaderBuilder {
    public static final LegacyBatchingEntityLoaderBuilder INSTANCE = new LegacyBatchingEntityLoaderBuilder();

    @Override
    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable persister, int batchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return new LegacyBatchingEntityLoader(persister, batchSize, lockMode, factory, influencers);
    }

    @Override
    protected UniqueEntityLoader buildBatchingLoader(OuterJoinLoadable persister, int batchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers influencers) {
        return new LegacyBatchingEntityLoader(persister, batchSize, lockOptions, factory, influencers);
    }

    public static class LegacyBatchingEntityLoader
    extends BatchingEntityLoader
    implements UniqueEntityLoader {
        private final int[] batchSizes;
        private final Loader[] loaders;

        public LegacyBatchingEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockMode lockMode, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
            super(persister);
            this.batchSizes = ArrayHelper.getBatchSizes(maxBatchSize);
            this.loaders = new Loader[this.batchSizes.length];
            for (int i = 0; i < this.batchSizes.length; ++i) {
                this.loaders[i] = new EntityLoader(persister, this.batchSizes[i], lockMode, factory, loadQueryInfluencers);
            }
        }

        public LegacyBatchingEntityLoader(OuterJoinLoadable persister, int maxBatchSize, LockOptions lockOptions, SessionFactoryImplementor factory, LoadQueryInfluencers loadQueryInfluencers) {
            super(persister);
            this.batchSizes = ArrayHelper.getBatchSizes(maxBatchSize);
            this.loaders = new Loader[this.batchSizes.length];
            for (int i = 0; i < this.batchSizes.length; ++i) {
                this.loaders[i] = new EntityLoader(persister, this.batchSizes[i], lockOptions, factory, loadQueryInfluencers);
            }
        }

        @Override
        public Object load(Serializable id, Object optionalObject, SessionImplementor session, LockOptions lockOptions) {
            Serializable[] batch = session.getPersistenceContext().getBatchFetchQueue().getEntityBatch(this.persister(), id, this.batchSizes[0], this.persister().getEntityMode());
            for (int i = 0; i < this.batchSizes.length - 1; ++i) {
                int smallBatchSize = this.batchSizes[i];
                if (batch[smallBatchSize - 1] == null) continue;
                Serializable[] smallBatch = new Serializable[smallBatchSize];
                System.arraycopy(batch, 0, smallBatch, 0, smallBatchSize);
                List results = this.loaders[i].loadEntityBatch(session, smallBatch, this.persister().getIdentifierType(), optionalObject, this.persister().getEntityName(), id, this.persister(), lockOptions);
                return this.getObjectFromList(results, id, session);
            }
            return ((UniqueEntityLoader)((Object)this.loaders[this.batchSizes.length - 1])).load(id, optionalObject, session);
        }
    }
}

