/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.loader.entity.plan;

import org.evosuite.shaded.org.hibernate.LockMode;
import org.evosuite.shaded.org.hibernate.LockOptions;
import org.evosuite.shaded.org.hibernate.MappingException;
import org.evosuite.shaded.org.hibernate.engine.spi.LoadQueryInfluencers;
import org.evosuite.shaded.org.hibernate.engine.spi.SessionFactoryImplementor;
import org.evosuite.shaded.org.hibernate.internal.CoreLogging;
import org.evosuite.shaded.org.hibernate.loader.entity.plan.AbstractLoadPlanBasedEntityLoader;
import org.evosuite.shaded.org.hibernate.loader.plan.exec.query.spi.QueryBuildingParameters;
import org.evosuite.shaded.org.hibernate.persister.entity.OuterJoinLoadable;
import org.evosuite.shaded.org.hibernate.type.Type;
import org.evosuite.shaded.org.jboss.logging.Logger;

public class EntityLoader
extends AbstractLoadPlanBasedEntityLoader {
    private static final Logger log = CoreLogging.logger(EntityLoader.class);

    public static Builder forEntity(OuterJoinLoadable persister) {
        return new Builder(persister);
    }

    private EntityLoader(SessionFactoryImplementor factory, OuterJoinLoadable persister, String[] uniqueKeyColumnNames, Type uniqueKeyType, QueryBuildingParameters buildingParameters) throws MappingException {
        super(persister, factory, uniqueKeyColumnNames, uniqueKeyType, buildingParameters);
        if (log.isDebugEnabled()) {
            if (buildingParameters.getLockOptions() != null) {
                log.debugf("Static select for entity %s [%s:%s]: %s", new Object[]{this.getEntityName(), buildingParameters.getLockOptions().getLockMode(), buildingParameters.getLockOptions().getTimeOut(), this.getStaticLoadQuery().getSqlStatement()});
            } else if (buildingParameters.getLockMode() != null) {
                log.debugf("Static select for entity %s [%s]: %s", (Object)this.getEntityName(), (Object)buildingParameters.getLockMode(), (Object)this.getStaticLoadQuery().getSqlStatement());
            }
        }
    }

    public static class Builder {
        private final OuterJoinLoadable persister;
        private int batchSize = 1;
        private LoadQueryInfluencers influencers = LoadQueryInfluencers.NONE;
        private LockMode lockMode = LockMode.NONE;
        private LockOptions lockOptions;

        public Builder(OuterJoinLoadable persister) {
            this.persister = persister;
        }

        public Builder withBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder withInfluencers(LoadQueryInfluencers influencers) {
            this.influencers = influencers;
            return this;
        }

        public Builder withLockMode(LockMode lockMode) {
            this.lockMode = lockMode;
            return this;
        }

        public Builder withLockOptions(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
            return this;
        }

        public EntityLoader byPrimaryKey() {
            return this.byUniqueKey(this.persister.getIdentifierColumnNames(), this.persister.getIdentifierType());
        }

        public EntityLoader byUniqueKey(String[] keyColumnNames, Type keyType) {
            return new EntityLoader(this.persister.getFactory(), this.persister, keyColumnNames, keyType, new QueryBuildingParameters(){

                @Override
                public LoadQueryInfluencers getQueryInfluencers() {
                    return Builder.this.influencers;
                }

                @Override
                public int getBatchSize() {
                    return Builder.this.batchSize;
                }

                @Override
                public LockMode getLockMode() {
                    return Builder.this.lockMode;
                }

                @Override
                public LockOptions getLockOptions() {
                    return Builder.this.lockOptions;
                }
            });
        }
    }
}

