/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.mapping;

import java.util.Iterator;
import org.evosuite.shaded.org.hibernate.MappingException;
import org.evosuite.shaded.org.hibernate.cfg.Mappings;
import org.evosuite.shaded.org.hibernate.engine.spi.Mapping;
import org.evosuite.shaded.org.hibernate.mapping.Collection;
import org.evosuite.shaded.org.hibernate.mapping.Column;
import org.evosuite.shaded.org.hibernate.mapping.PersistentClass;
import org.evosuite.shaded.org.hibernate.mapping.PrimaryKey;
import org.evosuite.shaded.org.hibernate.mapping.Selectable;
import org.evosuite.shaded.org.hibernate.mapping.ValueVisitor;
import org.evosuite.shaded.org.hibernate.type.CollectionType;

public class Set
extends Collection {
    @Override
    public void validate(Mapping mapping) throws MappingException {
        super.validate(mapping);
    }

    public Set(Mappings mappings, PersistentClass owner) {
        super(mappings, owner);
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public CollectionType getDefaultCollectionType() {
        if (this.isSorted()) {
            return this.getMappings().getTypeResolver().getTypeFactory().sortedSet(this.getRole(), this.getReferencedPropertyName(), this.getComparator());
        }
        if (this.hasOrder()) {
            return this.getMappings().getTypeResolver().getTypeFactory().orderedSet(this.getRole(), this.getReferencedPropertyName());
        }
        return this.getMappings().getTypeResolver().getTypeFactory().set(this.getRole(), this.getReferencedPropertyName());
    }

    @Override
    void createPrimaryKey() {
        if (!this.isOneToMany()) {
            PrimaryKey pk = new PrimaryKey();
            pk.addColumns(this.getKey().getColumnIterator());
            Iterator<Selectable> iter = this.getElement().getColumnIterator();
            while (iter.hasNext()) {
                Column col;
                Selectable selectable = iter.next();
                if (!(selectable instanceof Column) || (col = (Column)selectable).isNullable()) continue;
                pk.addColumn(col);
            }
            if (pk.getColumnSpan() != this.getKey().getColumnSpan()) {
                this.getCollectionTable().setPrimaryKey(pk);
            }
        }
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }
}

