/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.binding;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.shaded.org.hibernate.AssertionFailure;
import org.evosuite.shaded.org.hibernate.FetchMode;
import org.evosuite.shaded.org.hibernate.engine.FetchStyle;
import org.evosuite.shaded.org.hibernate.engine.FetchTiming;
import org.evosuite.shaded.org.hibernate.engine.spi.CascadeStyle;
import org.evosuite.shaded.org.hibernate.engine.spi.CascadeStyles;
import org.evosuite.shaded.org.hibernate.metamodel.binding.AbstractAttributeBinding;
import org.evosuite.shaded.org.hibernate.metamodel.binding.AbstractCollectionElement;
import org.evosuite.shaded.org.hibernate.metamodel.binding.AttributeBindingContainer;
import org.evosuite.shaded.org.hibernate.metamodel.binding.BasicCollectionElement;
import org.evosuite.shaded.org.hibernate.metamodel.binding.Caching;
import org.evosuite.shaded.org.hibernate.metamodel.binding.CollectionElementNature;
import org.evosuite.shaded.org.hibernate.metamodel.binding.CollectionKey;
import org.evosuite.shaded.org.hibernate.metamodel.binding.CompositeCollectionElement;
import org.evosuite.shaded.org.hibernate.metamodel.binding.CustomSQL;
import org.evosuite.shaded.org.hibernate.metamodel.binding.ManyToAnyCollectionElement;
import org.evosuite.shaded.org.hibernate.metamodel.binding.ManyToManyCollectionElement;
import org.evosuite.shaded.org.hibernate.metamodel.binding.OneToManyCollectionElement;
import org.evosuite.shaded.org.hibernate.metamodel.binding.PluralAttributeBinding;
import org.evosuite.shaded.org.hibernate.metamodel.domain.PluralAttribute;
import org.evosuite.shaded.org.hibernate.metamodel.relational.Table;
import org.evosuite.shaded.org.hibernate.metamodel.relational.TableSpecification;
import org.evosuite.shaded.org.hibernate.persister.collection.CollectionPersister;

public abstract class AbstractPluralAttributeBinding
extends AbstractAttributeBinding
implements PluralAttributeBinding {
    private final CollectionKey collectionKey;
    private final AbstractCollectionElement collectionElement;
    private Table collectionTable;
    private FetchTiming fetchTiming;
    private FetchStyle fetchStyle;
    private int batchSize = -1;
    private CascadeStyle cascadeStyle;
    private boolean orphanDelete;
    private Caching caching;
    private boolean inverse;
    private boolean mutable = true;
    private Class<? extends CollectionPersister> collectionPersisterClass;
    private String where;
    private String orderBy;
    private boolean sorted;
    private Comparator comparator;
    private String comparatorClassName;
    private String customLoaderName;
    private CustomSQL customSqlInsert;
    private CustomSQL customSqlUpdate;
    private CustomSQL customSqlDelete;
    private CustomSQL customSqlDeleteAll;
    private String referencedPropertyName;
    private final Map filters = new HashMap();
    private final Set<String> synchronizedTables = new HashSet<String>();

    protected AbstractPluralAttributeBinding(AttributeBindingContainer container, PluralAttribute attribute, CollectionElementNature collectionElementNature) {
        super(container, attribute);
        this.collectionKey = new CollectionKey(this);
        this.collectionElement = this.interpretNature(collectionElementNature);
    }

    private AbstractCollectionElement interpretNature(CollectionElementNature collectionElementNature) {
        switch (collectionElementNature) {
            case BASIC: {
                return new BasicCollectionElement(this);
            }
            case COMPOSITE: {
                return new CompositeCollectionElement(this);
            }
            case ONE_TO_MANY: {
                return new OneToManyCollectionElement(this);
            }
            case MANY_TO_MANY: {
                return new ManyToManyCollectionElement(this);
            }
            case MANY_TO_ANY: {
                return new ManyToAnyCollectionElement(this);
            }
        }
        throw new AssertionFailure("Unknown collection element nature : " + (Object)((Object)collectionElementNature));
    }

    @Override
    public PluralAttribute getAttribute() {
        return (PluralAttribute)super.getAttribute();
    }

    @Override
    public boolean isAssociation() {
        return this.collectionElement.getCollectionElementNature() == CollectionElementNature.MANY_TO_ANY || this.collectionElement.getCollectionElementNature() == CollectionElementNature.MANY_TO_MANY || this.collectionElement.getCollectionElementNature() == CollectionElementNature.ONE_TO_MANY;
    }

    @Override
    public TableSpecification getCollectionTable() {
        return this.collectionTable;
    }

    public void setCollectionTable(Table collectionTable) {
        this.collectionTable = collectionTable;
    }

    @Override
    public CollectionKey getCollectionKey() {
        return this.collectionKey;
    }

    @Override
    public AbstractCollectionElement getCollectionElement() {
        return this.collectionElement;
    }

    @Override
    public CascadeStyle getCascadeStyle() {
        return this.cascadeStyle;
    }

    @Override
    public void setCascadeStyles(Iterable<CascadeStyle> cascadeStyles) {
        ArrayList<CascadeStyle> cascadeStyleList = new ArrayList<CascadeStyle>();
        for (CascadeStyle style : cascadeStyles) {
            if (style != CascadeStyles.NONE) {
                cascadeStyleList.add(style);
            }
            if (style != CascadeStyles.DELETE_ORPHAN && style != CascadeStyles.ALL_DELETE_ORPHAN) continue;
            this.orphanDelete = true;
        }
        this.cascadeStyle = cascadeStyleList.isEmpty() ? CascadeStyles.NONE : (cascadeStyleList.size() == 1 ? (CascadeStyle)cascadeStyleList.get(0) : new CascadeStyles.MultipleCascadeStyle(cascadeStyleList.toArray(new CascadeStyle[cascadeStyleList.size()])));
    }

    @Override
    public boolean isOrphanDelete() {
        return this.orphanDelete;
    }

    @Override
    public FetchMode getFetchMode() {
        if (this.getFetchStyle() == FetchStyle.JOIN) {
            return FetchMode.JOIN;
        }
        return FetchMode.SELECT;
    }

    @Override
    public FetchTiming getFetchTiming() {
        return this.fetchTiming;
    }

    @Override
    public void setFetchTiming(FetchTiming fetchTiming) {
        this.fetchTiming = fetchTiming;
    }

    @Override
    public FetchStyle getFetchStyle() {
        return this.fetchStyle;
    }

    @Override
    public void setFetchStyle(FetchStyle fetchStyle) {
        this.fetchStyle = fetchStyle;
    }

    @Override
    public String getCustomLoaderName() {
        return this.customLoaderName;
    }

    public void setCustomLoaderName(String customLoaderName) {
        this.customLoaderName = customLoaderName;
    }

    @Override
    public CustomSQL getCustomSqlInsert() {
        return this.customSqlInsert;
    }

    public void setCustomSqlInsert(CustomSQL customSqlInsert) {
        this.customSqlInsert = customSqlInsert;
    }

    @Override
    public CustomSQL getCustomSqlUpdate() {
        return this.customSqlUpdate;
    }

    public void setCustomSqlUpdate(CustomSQL customSqlUpdate) {
        this.customSqlUpdate = customSqlUpdate;
    }

    @Override
    public CustomSQL getCustomSqlDelete() {
        return this.customSqlDelete;
    }

    public void setCustomSqlDelete(CustomSQL customSqlDelete) {
        this.customSqlDelete = customSqlDelete;
    }

    @Override
    public CustomSQL getCustomSqlDeleteAll() {
        return this.customSqlDeleteAll;
    }

    public void setCustomSqlDeleteAll(CustomSQL customSqlDeleteAll) {
        this.customSqlDeleteAll = customSqlDeleteAll;
    }

    @Override
    public Class<? extends CollectionPersister> getCollectionPersisterClass() {
        return this.collectionPersisterClass;
    }

    public void setCollectionPersisterClass(Class<? extends CollectionPersister> collectionPersisterClass) {
        this.collectionPersisterClass = collectionPersisterClass;
    }

    @Override
    public Caching getCaching() {
        return this.caching;
    }

    public void setCaching(Caching caching) {
        this.caching = caching;
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    @Override
    public boolean isInverse() {
        return this.inverse;
    }

    public void setInverse(boolean inverse) {
        this.inverse = inverse;
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public String getReferencedPropertyName() {
        return this.referencedPropertyName;
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public String getComparatorClassName() {
        return this.comparatorClassName;
    }

    public void addFilter(String name, String condition) {
        this.filters.put(name, condition);
    }

    @Override
    public Map getFilterMap() {
        return this.filters;
    }
}

