/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.hibernate.metamodel.relational;

import org.evosuite.shaded.org.hibernate.MappingException;
import org.evosuite.shaded.org.hibernate.dialect.Dialect;
import org.evosuite.shaded.org.hibernate.metamodel.relational.Exportable;
import org.evosuite.shaded.org.hibernate.metamodel.relational.ObjectName;
import org.evosuite.shaded.org.hibernate.metamodel.relational.Schema;

public class Sequence
implements Exportable {
    private final Schema schema;
    private final String name;
    private final String qualifiedName;
    private int initialValue = 1;
    private int incrementSize = 1;

    public Sequence(Schema schema, String name) {
        this.schema = schema;
        this.name = name;
        this.qualifiedName = new ObjectName(schema, name).toText();
    }

    public Sequence(Schema schema, String name, int initialValue, int incrementSize) {
        this(schema, name);
        this.initialValue = initialValue;
        this.incrementSize = incrementSize;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getExportIdentifier() {
        return this.qualifiedName;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public int getIncrementSize() {
        return this.incrementSize;
    }

    @Override
    public String[] sqlCreateStrings(Dialect dialect) throws MappingException {
        return dialect.getCreateSequenceStrings(this.name, this.initialValue, this.incrementSize);
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) throws MappingException {
        return dialect.getDropSequenceStrings(this.name);
    }
}

